/*
 * Decompiled with CFR 0.152.
 */
package org.undp.weblog;

import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.loader.PackageLoader;
import com.arsdigita.portal.apportlet.AppPortletType;
import com.arsdigita.runtime.ScriptContext;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationType;
import org.apache.log4j.Logger;
import org.undp.weblog.WebLogApplication;
import org.undp.weblog.ui.WebLogPortlet;

public class Loader
extends PackageLoader {
    private static final Logger s_log = Logger.getLogger(Loader.class);

    public void run(ScriptContext ctx) {
        new KernelExcursion(){

            public void excurse() {
                this.setEffectiveParty(Kernel.getSystemParty());
                ApplicationType weblogType = Loader.this.loadWebLogApplicationType();
                Loader.this.loadWebLogPortletType(weblogType);
                Loader.setupDefaultWebLogApplicationInstance();
            }
        }.run();
        s_log.info((Object)"Done");
    }

    private ApplicationType loadWebLogApplicationType() {
        s_log.info((Object)"WebLog Loader - setting up application type");
        ApplicationType type = new ApplicationType("WebLog", WebLogApplication.BASE_DATA_OBJECT_TYPE);
        type.setDescription("The WebLog application enables user .....");
        type.save();
        return type;
    }

    private void loadWebLogPortletType(ApplicationType webLogAppType) {
        AppPortletType type = AppPortletType.createAppPortletType((String)"WebLog Portlet", (String)"wide", (String)WebLogPortlet.BASE_DATA_OBJECT_TYPE);
        type.setDescription("Displays WebLogs for this portal.");
        type.setProviderApplicationType(webLogAppType);
        type.setPortalApplication(true);
        type.save();
    }

    public static void setupDefaultWebLogApplicationInstance() {
        Application parent = Application.retrieveApplicationForPath((String)"/admin/");
        s_log.debug((Object)"Creating WebLogApplication instance ...");
        WebLogApplication app = WebLogApplication.create("blog", "Weblog", parent);
        app.setDescription("Default WebLog application instance.");
        app.save();
        s_log.debug((Object)"WebLog instance  created.");
    }
}

