/*
 * Decompiled with CFR 0.152.
 */
package org.undp.weblog;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;
import org.undp.weblog.WebLogApplication;
import org.undp.weblog.WebLogComment;

public class WebLog
extends ACSObject {
    public static final String BASE_DATA_OBJECT_TYPE = WebLog.class.getName();
    public static final String PARAM_TITLE = "title";
    public static final String PARAM_LEAD = "lead";
    public static final String PARAM_BODY = "body";
    public static final String PARAM_MODIFIED = "modified";
    public static final String PARAM_APPLICATION = "webLogApp";
    public static final String PARAM_OWNER = "owner";
    private static final Logger s_log = Logger.getLogger(WebLog.class);

    public WebLog() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public WebLog(DataObject dataObject) {
        super(dataObject);
    }

    public WebLog(BigDecimal id) {
        super(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public void setTitle(String title) {
        this.set(PARAM_TITLE, title);
    }

    public void setLead(String lead) {
        this.set(PARAM_LEAD, lead);
    }

    public void setBody(String body) {
        this.set(PARAM_BODY, body);
    }

    public void setApplication(WebLogApplication app) {
        this.setAssociation(PARAM_APPLICATION, (DomainObject)app);
    }

    public void setOwner(User owner) {
        this.setAssociation(PARAM_OWNER, (DomainObject)owner);
    }

    public String getTitle() {
        return (String)this.get(PARAM_TITLE);
    }

    public String getLead() {
        return (String)this.get(PARAM_LEAD);
    }

    public String getBody() {
        return (String)this.get(PARAM_BODY);
    }

    public Date getModified() {
        return (Date)this.get(PARAM_MODIFIED);
    }

    public WebLogApplication getApplication() {
        DataObject entityAppData = (DataObject)this.get(PARAM_APPLICATION);
        if (entityAppData != null) {
            return new WebLogApplication(entityAppData);
        }
        return null;
    }

    public User getOwner() {
        DataObject entityData = (DataObject)this.get(PARAM_OWNER);
        if (entityData != null) {
            return User.retrieve((DataObject)entityData);
        }
        return null;
    }

    protected void beforeSave() {
        this.set(PARAM_MODIFIED, new Date());
        super.beforeSave();
    }

    protected void beforeDelete() {
        DataCollection coll = SessionManager.getSession().retrieve(WebLogComment.BASE_DATA_OBJECT_TYPE);
        coll.addEqualsFilter("webLog.id", (Object)this.getID());
        while (coll.next()) {
            WebLogComment comment = new WebLogComment(coll.getDataObject());
            comment.delete();
        }
        coll.close();
        super.beforeDelete();
    }

    public DataCollection getComments() {
        DataCollection coll = SessionManager.getSession().retrieve(WebLogComment.BASE_DATA_OBJECT_TYPE);
        coll.addEqualsFilter("webLog.id", (Object)this.getID());
        coll.addOrder("modified desc");
        return coll;
    }

    protected void afterSave() {
        super.afterSave();
        PermissionService.setContext((ACSObject)this, (ACSObject)this.getApplication());
    }
}

