/*
 * Decompiled with CFR 0.152.
 */
package org.undp.weblog;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.web.Application;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class WebLogApplication
extends Application {
    private static final Logger s_log = Logger.getLogger(WebLogApplication.class);
    public static final String BASE_DATA_OBJECT_TYPE = WebLogApplication.class.getName();

    public WebLogApplication(DataObject obj) {
        super(obj);
    }

    public WebLogApplication(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public WebLogApplication(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public static WebLogApplication create(String urlName, String title, Application parent) {
        WebLogApplication webLogApplication = (WebLogApplication)Application.createApplication((String)BASE_DATA_OBJECT_TYPE, (String)urlName, (String)title, (Application)parent);
        webLogApplication.save();
        return webLogApplication;
    }

    protected void afterSave() {
        super.afterSave();
        Party currentParty = Kernel.getContext().getParty();
        final PermissionDescriptor pd = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)this, currentParty);
        new KernelExcursion(){

            protected void excurse() {
                this.setParty(Kernel.getSystemParty());
                PermissionService.grantPermission((PermissionDescriptor)pd);
            }
        }.run();
    }

    public String getServletPath() {
        return "/weblog";
    }
}

