/*
 * Decompiled with CFR 0.152.
 */
package org.undp.weblog.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.form.DHTMLEditor;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import org.undp.weblog.WebLog;
import org.undp.weblog.WebLogComment;
import org.undp.weblog.ui.WebLogView;
import org.undp.weblog.util.GlobalizationUtil;

public class WebLogCommentEditForm
extends Form
implements FormInitListener,
FormValidationListener,
FormProcessListener {
    private static final String NAME_COMMENT = "comment";
    private final WebLogView m_parent;
    private Submit m_save;
    private final boolean m_createNew;

    public WebLogCommentEditForm(WebLogView parent, boolean createNew) {
        super("webLogCommentEditForm");
        this.m_parent = parent;
        this.m_createNew = createNew;
        this.setMethod("POST");
        this.add((Component)new Label(GlobalizationUtil.localize("webLogCommentEditForm.comment")), 12);
        DHTMLEditor body = new DHTMLEditor(NAME_COMMENT);
        body.setCols(80);
        body.setRows(20);
        this.add((Component)body);
        this.add((Component)new Label(""));
        SimpleContainer buttons = new SimpleContainer();
        this.m_save = new Submit(GlobalizationUtil.localize("saveButton"));
        buttons.add((Component)this.m_save);
        buttons.add((Component)new Submit(GlobalizationUtil.localize("cancelButton")));
        this.add((Component)buttons);
        this.addInitListener(this);
        this.addValidationListener(this);
        this.addProcessListener(this);
    }

    public void init(FormSectionEvent e) throws FormProcessException {
        BigDecimal enityID;
        if (!this.m_createNew && (enityID = this.m_parent.getEntityID(e.getPageState())) != null) {
            WebLogComment entity = new WebLogComment(enityID);
            FormData data = e.getFormData();
            data.put((Object)NAME_COMMENT, (Object)entity.getComment());
        }
    }

    public void validate(FormSectionEvent e) throws FormProcessException {
        if (this.m_save.isSelected(e.getPageState())) {
            this.validate(e.getFormData());
        }
    }

    private boolean validate(FormData data) {
        String comment = (String)data.get((Object)NAME_COMMENT);
        if (comment == null || comment.length() == 0) {
            data.addError(NAME_COMMENT, GlobalizationUtil.localize("error.parameterRequired"));
        } else if (comment.length() > 4000) {
            data.addError(NAME_COMMENT, GlobalizationUtil.localize("error.parameterSize4000"));
        }
        return data.isValid();
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        PageState ps = e.getPageState();
        if (this.m_save.isSelected(ps)) {
            FormData data = e.getFormData();
            if (this.validate(data)) {
                WebLogComment entity;
                String comment = (String)data.get((Object)NAME_COMMENT);
                if (this.m_createNew) {
                    entity = new WebLogComment();
                    entity.setWebLog(new WebLog((BigDecimal)this.m_parent.getParentIDParam().transformValue(ps.getRequest())));
                } else {
                    BigDecimal enityID = (BigDecimal)this.m_parent.getEntityIDParam().transformValue(e.getPageState().getRequest());
                    entity = new WebLogComment(enityID);
                }
                entity.setOwner(Web.getContext().getUser());
                entity.setComment(comment);
                entity.save();
                this.processBack(ps);
            }
        } else {
            this.processBack(ps);
        }
    }

    protected void processBack(PageState ps) {
        this.m_parent.setEntityID(ps, (BigDecimal)this.m_parent.getParentIDParam().transformValue(ps.getRequest()));
        this.m_parent.displayWebLogDetail(ps);
    }
}

