/*
 * Decompiled with CFR 0.152.
 */
package org.undp.weblog.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import org.undp.weblog.WebLog;
import org.undp.weblog.WebLogComment;
import org.undp.weblog.ui.WebLogCommentsListTableModel;
import org.undp.weblog.ui.WebLogView;

public class WebLogCommentsList
extends Table
implements TableActionListener {
    public static final String[] HEADERS = new String[]{"Comment", "Autor", "Modified", "", ""};
    private final WebLogView m_parent;

    public WebLogCommentsList(WebLogView parent, final RequestLocal webLogRequestLocal) {
        super(new TableModelBuilder(){
            private boolean m_locked = false;

            public TableModel makeModel(Table t, PageState ps) {
                return new WebLogCommentsListTableModel((WebLog)((Object)webLogRequestLocal.get(ps)));
            }

            public void lock() {
                this.m_locked = true;
            }

            public boolean isLocked() {
                return this.m_locked;
            }
        }, (Object[])HEADERS);
        this.m_parent = parent;
        this.addTableActionListener(this);
    }

    public void cellSelected(TableActionEvent e) {
        if (this.m_parent != null) {
            int col = e.getColumn();
            BigDecimal entityID = new BigDecimal((String)e.getRowKey());
            WebLogComment entity = new WebLogComment(entityID);
            if (entity != null && (this.m_parent.canUserAdminApplication() || Web.getContext().getUser().equals((Object)entity.getOwner()))) {
                PageState ps = e.getPageState();
                switch (col) {
                    case 3: {
                        this.m_parent.setEntityID(ps, entityID);
                        this.m_parent.setParentID(ps, entity.getWebLog().getID());
                        this.m_parent.displayWebLogCommentEditForm(ps);
                        break;
                    }
                    case 4: {
                        this.m_parent.setEntityID(ps, entity.getWebLog().getID());
                        entity.delete();
                        this.m_parent.displayWebLogDetail(ps);
                    }
                }
            }
        }
    }

    public void headSelected(TableActionEvent e) {
        throw new UnsupportedOperationException();
    }
}

