/*
 * Decompiled with CFR 0.152.
 */
package org.undp.weblog.ui;

import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.web.Application;
import com.arsdigita.web.Web;
import org.undp.weblog.WebLog;
import org.undp.weblog.WebLogComment;
import org.undp.weblog.WebLogConstants;
import org.undp.weblog.ui.WebLogCommentsList;
import org.undp.weblog.util.GlobalizationUtil;

public class WebLogCommentsListTableModel
implements TableModel,
WebLogConstants {
    private final DataCollection m_coll;
    private WebLogComment m_entity = null;
    private boolean m_hasNext;
    private final User m_user;
    private final boolean m_userIsAdmin;

    public WebLogCommentsListTableModel(WebLog webLog) {
        this.m_coll = webLog.getComments();
        this.m_hasNext = true;
        Application application = Web.getContext().getApplication();
        this.m_user = Web.getContext().getUser();
        PermissionDescriptor perm = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)application, (Party)this.m_user);
        this.m_userIsAdmin = PermissionService.checkPermission((PermissionDescriptor)perm);
    }

    public int getColumnCount() {
        return WebLogCommentsList.HEADERS.length;
    }

    public Object getElementAt(int columnIndex) {
        if (this.m_entity != null) {
            String entityID = this.m_entity.getID().toString();
            switch (columnIndex) {
                case 0: {
                    return new Label(this.m_entity.getComment(), false);
                }
                case 1: {
                    return new Label(this.m_entity.getOwner().getDisplayName());
                }
                case 2: {
                    return new Label(dateTimeFormat.format(this.m_entity.getModified()));
                }
                case 3: {
                    if (!this.m_userIsAdmin && !this.m_user.equals((Object)this.m_entity.getOwner())) break;
                    return new ControlLink(GlobalizationUtil.localize("webLogCommentsList.edit"));
                }
                case 4: {
                    if (!this.m_userIsAdmin && !this.m_user.equals((Object)this.m_entity.getOwner())) break;
                    ControlLink cl = new ControlLink(GlobalizationUtil.localize("webLogCommentsList.delete"));
                    cl.setOnClick(" return confirm('" + GlobalizationUtil.localize("confirmDelete") + "');");
                    return cl;
                }
            }
        }
        return null;
    }

    public boolean nextRow() {
        if (this.m_hasNext) {
            this.m_hasNext = this.m_coll.next();
            if (this.m_hasNext) {
                this.m_entity = new WebLogComment(this.m_coll.getDataObject());
            } else {
                this.m_entity = null;
                this.m_coll.close();
            }
        }
        return this.m_hasNext;
    }

    public Object getKeyAt(int columnIndex) {
        if (this.m_entity != null) {
            return this.m_entity.getID().toString();
        }
        return null;
    }
}

