/*
 * Decompiled with CFR 0.152.
 */
package org.undp.weblog.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import org.undp.weblog.WebLog;
import org.undp.weblog.WebLogConstants;
import org.undp.weblog.ui.WebLogCommentsList;
import org.undp.weblog.ui.WebLogDetail;
import org.undp.weblog.ui.WebLogView;
import org.undp.weblog.util.GlobalizationUtil;

public class WebLogDetailPane
extends GridPanel
implements WebLogConstants {
    private static final String NAME_TITLE = "title";
    private static final String NAME_LEAD = "lead";
    private static final String NAME_BODY = "body";
    private final WebLogView m_parent;
    private final ActionLink m_edit;
    private final ActionLink m_delete;
    private final ActionLink m_addComment;

    public WebLogDetailPane(WebLogView parent) {
        super(1);
        this.m_parent = parent;
        RequestLocal entityRequest = new RequestLocal(){

            protected Object initialValue(PageState ps) {
                BigDecimal detailID = WebLogDetailPane.this.m_parent.getEntityID(ps);
                return new WebLog(detailID);
            }
        };
        GridPanel detail = new GridPanel(1);
        detail.add((Component)new WebLogDetail(entityRequest));
        detail.add((Component)new WebLogCommentsList(this.m_parent, entityRequest));
        this.add((Component)detail);
        this.m_addComment = new ActionLink(GlobalizationUtil.localize("webLogDetailPane.addComment"));
        this.m_addComment.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                WebLogDetailPane.this.m_parent.setParentID(ps, (BigDecimal)WebLogDetailPane.this.m_parent.getEntityIDParam().transformValue(ps.getRequest()));
                WebLogDetailPane.this.m_parent.displayWebLogCommentCreateForm(ps);
            }
        });
        this.add((Component)this.m_addComment);
        this.add((Component)new Label("&nbsp;", false));
        ActionLink link = new ActionLink(GlobalizationUtil.localize("webLogDetailPane.detailsList"));
        link.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WebLogDetailPane.this.m_parent.displayWebLogsList(e.getPageState());
            }
        });
        this.add((Component)link);
        this.m_edit = new ActionLink(GlobalizationUtil.localize("webLogDetailPane.edit"));
        this.m_edit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (WebLogDetailPane.this.m_parent.canUserAdminApplication()) {
                    PageState ps = e.getPageState();
                    WebLogDetailPane.this.m_parent.setEntityID(ps, (BigDecimal)WebLogDetailPane.this.m_parent.getEntityIDParam().transformValue(ps.getRequest()));
                    WebLogDetailPane.this.m_parent.displayWebLogEditForm(ps, true);
                }
            }
        });
        this.add((Component)this.m_edit);
        this.m_delete = new ActionLink(GlobalizationUtil.localize("webLogDetailPane.delete"));
        this.m_delete.setOnClick(" return confirm('" + GlobalizationUtil.localize("confirmDelete") + "');");
        this.m_delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (WebLogDetailPane.this.m_parent.canUserAdminApplication()) {
                    PageState ps = e.getPageState();
                    BigDecimal detailID = (BigDecimal)WebLogDetailPane.this.m_parent.getEntityIDParam().transformValue(ps.getRequest());
                    WebLog entity = new WebLog(detailID);
                    entity.delete();
                    WebLogDetailPane.this.m_parent.displayWebLogsList(ps);
                }
            }
        });
        this.add((Component)this.m_delete);
    }

    public void generateXML(PageState ps, Element p) {
        boolean canAdmin = this.m_parent.canUserAdminApplication();
        this.m_edit.setVisible(ps, canAdmin);
        this.m_delete.setVisible(ps, canAdmin);
        super.generateXML(ps, p);
    }
}

