/*
 * Decompiled with CFR 0.152.
 */
package org.undp.weblog.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.form.DHTMLEditor;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import org.undp.weblog.WebLog;
import org.undp.weblog.WebLogApplication;
import org.undp.weblog.ui.WebLogView;
import org.undp.weblog.util.GlobalizationUtil;

public class WebLogEditForm
extends Form
implements FormInitListener,
FormValidationListener,
FormProcessListener {
    private static final String NAME_TITLE = "title";
    private static final String NAME_LEAD = "lead";
    private static final String NAME_BODY = "body";
    private final WebLogView m_parent;
    private Submit m_save;
    private final boolean m_createNew;

    public WebLogEditForm(WebLogView parent, boolean createNew) {
        super("webLogEditForm");
        this.m_parent = parent;
        this.m_createNew = createNew;
        this.setMethod("POST");
        this.add((Component)new Label(GlobalizationUtil.localize("webLogEditForm.title")), 12);
        this.add((Component)new TextField(NAME_TITLE));
        this.add((Component)new Label(GlobalizationUtil.localize("webLogEditForm.lead")), 12);
        TextArea lead = new TextArea(NAME_LEAD);
        lead.setCols(80);
        lead.setRows(12);
        this.add((Component)lead);
        this.add((Component)new Label(GlobalizationUtil.localize("webLogEditForm.body")), 12);
        DHTMLEditor body = new DHTMLEditor(NAME_BODY);
        body.setCols(80);
        body.setRows(20);
        this.add((Component)body);
        this.add((Component)new Label(""));
        SimpleContainer buttons = new SimpleContainer();
        this.m_save = new Submit(GlobalizationUtil.localize("saveButton"));
        buttons.add((Component)this.m_save);
        buttons.add((Component)new Submit(GlobalizationUtil.localize("cancelButton")));
        this.add((Component)buttons);
        this.addInitListener(this);
        this.addValidationListener(this);
        this.addProcessListener(this);
    }

    public void init(FormSectionEvent e) throws FormProcessException {
        BigDecimal enityID;
        if (!this.m_createNew && (enityID = this.m_parent.getEntityID(e.getPageState())) != null) {
            WebLog entity = new WebLog(enityID);
            FormData data = e.getFormData();
            data.put((Object)NAME_TITLE, (Object)entity.getTitle());
            data.put((Object)NAME_LEAD, (Object)entity.getLead());
            data.put((Object)NAME_BODY, (Object)entity.getBody());
        }
    }

    public void validate(FormSectionEvent e) throws FormProcessException {
        if (this.m_save.isSelected(e.getPageState())) {
            this.validate(e.getFormData());
        }
    }

    private boolean validate(FormData data) {
        String title;
        if (!this.m_parent.canUserAdminApplication()) {
            data.addError("Insufficient rights");
        }
        if ((title = (String)data.get((Object)NAME_TITLE)) == null || title.length() == 0) {
            data.addError(NAME_TITLE, GlobalizationUtil.localize("error.parameterRequired"));
        } else if (title.length() > 200) {
            data.addError(NAME_TITLE, GlobalizationUtil.localize("error.parameterSize200"));
        }
        String lead = (String)data.get((Object)NAME_LEAD);
        if (lead == null || lead.length() == 0) {
            data.addError(NAME_LEAD, GlobalizationUtil.localize("error.parameterRequired"));
        } else if (lead.length() > 4000) {
            data.addError(NAME_LEAD, GlobalizationUtil.localize("error.parameterSize4000"));
        }
        String body = (String)data.get((Object)NAME_BODY);
        if (body == null || body.length() == 0) {
            data.addError(NAME_BODY, GlobalizationUtil.localize("error.parameterRequired"));
        }
        return data.isValid();
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        PageState ps = e.getPageState();
        if (this.m_save.isSelected(ps)) {
            FormData data = e.getFormData();
            if (this.validate(data)) {
                WebLog entity;
                String title = (String)data.get((Object)NAME_TITLE);
                String lead = (String)data.get((Object)NAME_LEAD);
                String body = (String)data.get((Object)NAME_BODY);
                if (this.m_createNew) {
                    entity = new WebLog();
                    entity.setApplication((WebLogApplication)Web.getContext().getApplication());
                    entity.setOwner(Web.getContext().getUser());
                } else {
                    BigDecimal enityID = (BigDecimal)this.m_parent.getEntityIDParam().transformValue(e.getPageState().getRequest());
                    entity = new WebLog(enityID);
                }
                entity.setTitle(title);
                entity.setLead(lead);
                entity.setBody(body);
                entity.save();
                this.processBack(ps);
            }
        } else {
            this.processBack(ps);
        }
    }

    protected WebLogView getParent() {
        return this.m_parent;
    }

    protected void processBack(PageState ps) {
        this.m_parent.displayWebLogsList(ps);
    }
}

