/*
 * Decompiled with CFR 0.152.
 */
package org.undp.weblog.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.ModalContainer;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.web.Application;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.undp.weblog.WebLog;
import org.undp.weblog.WebLogConstants;
import org.undp.weblog.ui.WebLogCommentEditForm;
import org.undp.weblog.ui.WebLogDetail;
import org.undp.weblog.ui.WebLogDetailPane;
import org.undp.weblog.ui.WebLogEditForm;
import org.undp.weblog.ui.WebLogsList;
import org.undp.weblog.util.GlobalizationUtil;

public class WebLogView
extends ModalContainer
implements WebLogConstants {
    private static final Logger s_log = Logger.getLogger(WebLogView.class);
    private GridPanel m_webLogsList;
    private ActionLink m_addTopic;
    private WebLogEditForm m_webLogCreateForm;
    private WebLogEditForm m_webLogEditForm;
    private WebLogEditForm m_webLogEditFormBack2detail;
    private WebLogDetailPane m_webLogDetail;
    private GridPanel m_webLogCommentCreateForm;
    private GridPanel m_webLogCommentEditForm;
    private final RequestLocal m_entityID = new RequestLocal();
    private final RequestLocal m_parentID = new RequestLocal();
    private final BigDecimalParameter m_entityIDparam;
    private final BigDecimalParameter m_parentIDparam;
    private final RequestLocal parentEntityRequest = new RequestLocal(){

        protected Object initialValue(PageState ps) {
            BigDecimal detailID = WebLogView.this.getParentID(ps);
            if (detailID == null) {
                detailID = (BigDecimal)WebLogView.this.getParentIDParam().transformValue(ps.getRequest());
            }
            return new WebLog(detailID);
        }
    };

    public WebLogView(BigDecimalParameter entityIDparam, BigDecimalParameter parentIDparam) {
        this.m_entityIDparam = entityIDparam;
        this.m_parentIDparam = parentIDparam;
        this.m_webLogsList = new GridPanel(1);
        this.m_webLogsList.add((Component)new WebLogsList(this));
        this.m_addTopic = new ActionLink(GlobalizationUtil.localize("webLogView.addTopic"));
        this.m_addTopic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (WebLogView.this.canUserAdminApplication()) {
                    PageState ps = e.getPageState();
                    WebLogView.this.displayWebLogCreateForm(ps);
                }
            }
        });
        this.m_webLogsList.add((Component)this.m_addTopic);
        this.add((Component)this.m_webLogsList);
        this.setDefaultComponent((Component)this.m_webLogsList);
        this.m_webLogCreateForm = new WebLogEditForm(this, true);
        this.add((Component)this.m_webLogCreateForm);
        this.m_webLogEditForm = new WebLogEditForm(this, false);
        this.add((Component)this.m_webLogEditForm);
        this.m_webLogEditFormBack2detail = new WebLogEditForm(this, false){

            @Override
            protected void processBack(PageState ps) {
                WebLogView parent = this.getParent();
                parent.setEntityID(ps, (BigDecimal)parent.getEntityIDParam().transformValue(ps.getRequest()));
                parent.displayWebLogDetail(ps);
            }
        };
        this.add((Component)this.m_webLogEditFormBack2detail);
        this.m_webLogDetail = new WebLogDetailPane(this);
        this.add((Component)this.m_webLogDetail);
        this.m_webLogCommentCreateForm = new GridPanel(1);
        this.m_webLogCommentCreateForm.add((Component)new WebLogDetail(this.parentEntityRequest));
        this.m_webLogCommentCreateForm.add((Component)new WebLogCommentEditForm(this, true));
        this.add((Component)this.m_webLogCommentCreateForm);
        this.m_webLogCommentEditForm = new GridPanel(1);
        this.m_webLogCommentEditForm.add((Component)new WebLogDetail(this.parentEntityRequest));
        this.m_webLogCommentEditForm.add((Component)new WebLogCommentEditForm(this, false));
        this.add((Component)this.m_webLogCommentEditForm);
    }

    public void displayWebLogsList(PageState ps) {
        this.setVisibleComponent(ps, (Component)this.m_webLogsList);
    }

    public void displayWebLogDetail(PageState ps) {
        this.setVisibleComponent(ps, (Component)this.m_webLogDetail);
    }

    public void displayWebLogCreateForm(PageState ps) {
        this.setVisibleComponent(ps, (Component)this.m_webLogCreateForm);
    }

    public void displayWebLogEditForm(PageState ps) {
        this.displayWebLogEditForm(ps, false);
    }

    public void displayWebLogEditForm(PageState ps, boolean backToDetail) {
        if (backToDetail) {
            this.setVisibleComponent(ps, (Component)this.m_webLogEditFormBack2detail);
        } else {
            this.setVisibleComponent(ps, (Component)this.m_webLogEditForm);
        }
    }

    public void displayWebLogCommentCreateForm(PageState ps) {
        this.setVisibleComponent(ps, (Component)this.m_webLogCommentCreateForm);
    }

    public void displayWebLogCommentEditForm(PageState ps) {
        this.setVisibleComponent(ps, (Component)this.m_webLogCommentEditForm);
    }

    public void generateXML(PageState ps, Element p) {
        this.m_addTopic.setVisible(ps, this.canUserAdminApplication());
        HttpServletRequest request = ps.getRequest();
        try {
            BigDecimal detailID = new BigDecimal(request.getParameter("wld_id"));
            this.setEntityID(ps, detailID);
            this.displayWebLogDetail(ps);
        }
        catch (Exception e) {
            // empty catch block
        }
        super.generateXML(ps, p);
    }

    protected BigDecimal getEntityID(PageState ps) {
        return (BigDecimal)this.m_entityID.get(ps);
    }

    protected void setEntityID(PageState ps, BigDecimal id) {
        ps.setValue((ParameterModel)this.m_entityIDparam, (Object)id);
        this.m_entityID.set(ps, (Object)id);
    }

    protected BigDecimal getParentID(PageState ps) {
        return (BigDecimal)this.m_parentID.get(ps);
    }

    protected void setParentID(PageState ps, BigDecimal id) {
        ps.setValue((ParameterModel)this.m_parentIDparam, (Object)id);
        this.m_parentID.set(ps, (Object)id);
    }

    protected BigDecimalParameter getEntityIDParam() {
        return this.m_entityIDparam;
    }

    protected BigDecimalParameter getParentIDParam() {
        return this.m_parentIDparam;
    }

    protected boolean canUserAdminApplication() {
        Application app = Web.getContext().getApplication();
        User user = Web.getContext().getUser();
        PermissionDescriptor perm = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)app, (Party)user);
        boolean result = PermissionService.checkPermission((PermissionDescriptor)perm);
        s_log.debug((Object)("canUserAdminApplication result is " + result));
        return result;
    }

    protected boolean canUserEditApplication() {
        PermissionDescriptor perm = new PermissionDescriptor(PrivilegeDescriptor.EDIT, (ACSObject)Web.getContext().getApplication(), (Party)Web.getContext().getUser());
        return PermissionService.checkPermission((PermissionDescriptor)perm);
    }
}

