/*
 * Decompiled with CFR 0.152.
 */
package org.undp.weblog.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import org.undp.weblog.WebLog;
import org.undp.weblog.WebLogApplication;
import org.undp.weblog.ui.WebLogView;
import org.undp.weblog.ui.WebLogsListTableModel;

public class WebLogsList
extends Table
implements TableActionListener {
    public static final String[] HEADERS = new String[]{"Title", "Modified", "Lead", "Read", "Comments"};
    public static final String[] HEADERS_ACTION = new String[]{"Title", "Modified", "Lead", "Read", "Comments", "", ""};
    private final WebLogView m_parent;

    public WebLogsList(final WebLogApplication application) {
        super(new TableModelBuilder(){
            private boolean m_locked = false;

            public TableModel makeModel(Table t, PageState state) {
                return new WebLogsListTableModel(application, HEADERS.length);
            }

            public void lock() {
                this.m_locked = true;
            }

            public boolean isLocked() {
                return this.m_locked;
            }
        }, (Object[])HEADERS);
        this.m_parent = null;
    }

    public WebLogsList(WebLogView parent) {
        super(new TableModelBuilder(){
            private boolean m_locked = false;

            public TableModel makeModel(Table t, PageState state) {
                return new WebLogsListTableModel((WebLogApplication)Web.getContext().getApplication(), HEADERS_ACTION.length);
            }

            public void lock() {
                this.m_locked = true;
            }

            public boolean isLocked() {
                return this.m_locked;
            }
        }, (Object[])HEADERS_ACTION);
        this.m_parent = parent;
        this.addTableActionListener(this);
    }

    public void cellSelected(TableActionEvent e) {
        if (this.m_parent != null && this.m_parent.canUserAdminApplication()) {
            int col = e.getColumn();
            BigDecimal entityID = new BigDecimal((String)e.getRowKey());
            if (entityID != null) {
                PageState ps = e.getPageState();
                switch (col) {
                    case 5: {
                        this.m_parent.setEntityID(ps, entityID);
                        this.m_parent.displayWebLogEditForm(ps);
                        break;
                    }
                    case 6: {
                        WebLog entity = new WebLog(entityID);
                        entity.delete();
                        this.m_parent.displayWebLogsList(ps);
                    }
                }
            }
        }
    }

    public void headSelected(TableActionEvent e) {
        throw new UnsupportedOperationException();
    }
}

