/*
 * Decompiled with CFR 0.152.
 */
package org.undp.weblog.ui;

import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.web.Web;
import org.undp.weblog.WebLog;
import org.undp.weblog.WebLogApplication;
import org.undp.weblog.WebLogComment;
import org.undp.weblog.WebLogConstants;
import org.undp.weblog.util.GlobalizationUtil;

public class WebLogsListTableModel
implements TableModel,
WebLogConstants {
    private final int m_columnCount;
    private final DataCollection m_coll;
    private WebLog m_entity = null;
    private boolean m_hasNext;
    private final String m_appURL;
    private final boolean m_userIsAdmin;

    public WebLogsListTableModel(WebLogApplication application, int columnCount) {
        this.m_columnCount = columnCount;
        this.m_coll = SessionManager.getSession().retrieve(WebLog.BASE_DATA_OBJECT_TYPE);
        this.m_coll.addEqualsFilter("webLogApp.id", (Object)application.getID());
        this.m_coll.addOrder("modified desc");
        this.m_hasNext = true;
        this.m_appURL = application.getPath();
        PermissionDescriptor perm = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)application, (Party)Web.getContext().getUser());
        this.m_userIsAdmin = PermissionService.checkPermission((PermissionDescriptor)perm);
    }

    public int getColumnCount() {
        return this.m_columnCount;
    }

    public Object getElementAt(int columnIndex) {
        if (this.m_entity != null) {
            String entityID = this.m_entity.getID().toString();
            switch (columnIndex) {
                case 0: {
                    Link l = new Link(this.m_entity.getTitle(), this.m_appURL);
                    l.setVar("wld_id", entityID);
                    return l;
                }
                case 1: {
                    return new Label(dateTimeFormat.format(this.m_entity.getModified()));
                }
                case 2: {
                    return new Label(this.m_entity.getLead(), false);
                }
                case 3: {
                    Link l = new Link(GlobalizationUtil.localize("webLogsList.readMore"), this.m_appURL);
                    l.setVar("wld_id", entityID);
                    return l;
                }
                case 4: {
                    DataCollection coll = SessionManager.getSession().retrieve(WebLogComment.BASE_DATA_OBJECT_TYPE);
                    coll.addEqualsFilter("webLog.id", (Object)this.m_entity.getID());
                    long commSize = coll.size();
                    coll.close();
                    String comments = commSize == 1L ? "1 comment" : commSize + " comments";
                    return new Label(comments);
                }
                case 5: {
                    if (!this.m_userIsAdmin) break;
                    return new ControlLink(GlobalizationUtil.localize("webLogsList.edit"));
                }
                case 6: {
                    if (!this.m_userIsAdmin) break;
                    ControlLink cl = new ControlLink(GlobalizationUtil.localize("webLogsList.delete"));
                    cl.setOnClick(" return confirm('" + GlobalizationUtil.localize("confirmDelete") + "');");
                    return cl;
                }
            }
        }
        return null;
    }

    public boolean nextRow() {
        if (this.m_hasNext) {
            this.m_hasNext = this.m_coll.next();
            if (this.m_hasNext) {
                this.m_entity = new WebLog(this.m_coll.getDataObject());
            } else {
                this.m_entity = null;
                this.m_coll.close();
            }
        }
        return this.m_hasNext;
    }

    public Object getKeyAt(int columnIndex) {
        if (this.m_entity != null) {
            return this.m_entity.getID().toString();
        }
        return null;
    }
}

