/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.cms.dublin;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.london.cms.dublin.DublinCoreConfig;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import java.util.Date;
import org.apache.log4j.Logger;

public class DublinCoreItem
extends ContentItem {
    private static final Logger logger = Logger.getLogger(DublinCoreItem.class);
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.london.cms.dublin.DublinCoreItem";
    private static final DublinCoreConfig s_config = new DublinCoreConfig();
    public static final String DCMI_OWNER = "dcOwner";
    public static final String DC_AUDIENCE = "dcAudience";
    public static final String DC_CONTRIBUTOR = "dcContributor";
    public static final String DC_COVERAGE = "dcCoverage";
    public static final String DC_COVERAGE_POSTCODE = "dcCoveragePostcode";
    public static final String DC_COVERAGE_SPATIAL_REF = "dcCoverageSpatialRef";
    public static final String DC_COVERAGE_UNIT = "dcCoverageUnit";
    public static final String DC_TEMPORAL_BEGIN = "dcTemporalBegin";
    public static final String DC_TEMPORAL_END = "dcTemporalEnd";
    public static final String DC_CREATOR_OWNER = "dcCreatorOwner";
    public static final String DC_CREATOR_CONTACT = "dcCreatorContact";
    public static final String DC_DESCRIPTION = "dcDescription";
    public static final String DC_IDENTIFIER = "dcIdentifier";
    public static final String DC_PRESERVATION = "dcPreservation";
    public static final String DC_PUBLISHER = "dcPublisher";
    public static final String DC_RELATION = "dcRelation";
    public static final String DC_RIGHTS = "dcRights";
    public static final String DC_SOURCE = "dcSource";
    public static final String DC_CCN_PORTAL_INSTANCE = "dcCcnPortalInstance";
    public static final String DC_DATE_VALID = "dcDateValid";
    public static final String DC_DISPOSAL_REVIEW = "dcDisposalReview";
    public static final String DC_LANGUAGE = "dcLanguage";
    public static final String DC_KEYWORDS = "dcKeywords";

    public static final DublinCoreConfig getConfig() {
        return s_config;
    }

    protected DublinCoreItem() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public DublinCoreItem(OID oid) {
        super(oid);
    }

    public DublinCoreItem(DataObject obj) {
        super(obj);
    }

    public DublinCoreItem(String type) {
        super(type);
    }

    public static DublinCoreItem create(ContentItem owner) {
        DublinCoreItem item = new DublinCoreItem();
        item.setOwner(owner);
        item.setName(owner.getName() + "-dublin-metadata");
        return item;
    }

    public static DublinCoreItem findByOwner(ContentItem owner) {
        DataCollection items = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        items.addEqualsFilter("dcOwner.id", (Object)owner.getID());
        if (items.next()) {
            DataObject obj = items.getDataObject();
            items.close();
            return (DublinCoreItem)DomainObjectFactory.newInstance((DataObject)obj);
        }
        return null;
    }

    protected void setOwner(ContentItem owner) {
        this.setAssociation(DCMI_OWNER, (DomainObject)owner);
    }

    public ContentItem getOwner() {
        DataObject dobj = (DataObject)this.get(DCMI_OWNER);
        Assert.exists((Object)dobj, DataObject.class);
        return (ContentItem)DomainObjectFactory.newInstance((DataObject)dobj);
    }

    public String getAudience() {
        return (String)this.get(DC_AUDIENCE);
    }

    public void setAudience(String audience) {
        this.set(DC_AUDIENCE, audience);
    }

    public String getContributor() {
        return (String)this.get(DC_CONTRIBUTOR);
    }

    public void setContributor(String contributor) {
        this.set(DC_CONTRIBUTOR, contributor);
    }

    public String getCoverage() {
        return (String)this.get(DC_COVERAGE);
    }

    public void setCoverage(String coverage) {
        this.set(DC_COVERAGE, coverage);
    }

    public String getCoveragePostcode() {
        return (String)this.get(DC_COVERAGE_POSTCODE);
    }

    public void setCoveragePostcode(String coveragepostcode) {
        this.set(DC_COVERAGE_POSTCODE, coveragepostcode);
    }

    public String getCoverageSpatialRef() {
        return (String)this.get(DC_COVERAGE_SPATIAL_REF);
    }

    public void setCoverageSpatialRef(String coverageSpatialRef) {
        this.set(DC_COVERAGE_SPATIAL_REF, coverageSpatialRef);
    }

    public String getCoverageUnit() {
        return (String)this.get(DC_COVERAGE_UNIT);
    }

    public void setCoverageUnit(String coverageunit) {
        this.set(DC_COVERAGE_UNIT, coverageunit);
    }

    public Date getTemporalBegin() {
        return (Date)this.get(DC_TEMPORAL_BEGIN);
    }

    public void setTemporalBegin(Date temporalbegin) {
        this.set(DC_TEMPORAL_BEGIN, temporalbegin);
    }

    public Date getTemporalEnd() {
        return (Date)this.get(DC_TEMPORAL_END);
    }

    public void setTemporalEnd(Date temporalend) {
        this.set(DC_TEMPORAL_END, temporalend);
    }

    public String getDateValid() {
        return (String)this.get(DC_DATE_VALID);
    }

    public void setDateValid(String dateValid) {
        this.set(DC_DATE_VALID, dateValid);
    }

    public String getDisposalReview() {
        return (String)this.get(DC_DISPOSAL_REVIEW);
    }

    public void setDisposalReview(String disposalReview) {
        this.set(DC_DISPOSAL_REVIEW, disposalReview);
    }

    public String getLanguage() {
        return this.getOwner().getLanguage();
    }

    public void setLanguage(String language) {
        throw new UnsupportedOperationException("Metadata language is no longer set explicitly. Language is pulled from underlying ContentItem");
    }

    public String getCreatorOwner() {
        return (String)this.get(DC_CREATOR_OWNER);
    }

    public void setCreatorOwner(String creator) {
        this.set(DC_CREATOR_OWNER, creator);
    }

    public String getCreatorContact() {
        return (String)this.get(DC_CREATOR_CONTACT);
    }

    public void setCreatorContact(String creator) {
        this.set(DC_CREATOR_CONTACT, creator);
    }

    public String getDescription() {
        return (String)this.get(DC_DESCRIPTION);
    }

    public void setDescription(String description) {
        this.set(DC_DESCRIPTION, description);
    }

    public String getIdentifier() {
        return (String)this.get(DC_IDENTIFIER);
    }

    public void setIdentifier(String identifier) {
        this.set(DC_IDENTIFIER, identifier);
    }

    public String getPreservation() {
        return (String)this.get(DC_PRESERVATION);
    }

    public void setPreservation(String preservation) {
        this.set(DC_PRESERVATION, preservation);
    }

    public String getPublisher() {
        return (String)this.get(DC_PUBLISHER);
    }

    public void setPublisher(String publisher) {
        this.set(DC_PUBLISHER, publisher);
    }

    public String getCcnPortalInstance() {
        return (String)this.get(DC_CCN_PORTAL_INSTANCE);
    }

    public void setCcnPortalInstance(String ccnPortalInstance) {
        this.set(DC_CCN_PORTAL_INSTANCE, ccnPortalInstance);
    }

    public String getRelation() {
        return (String)this.get(DC_RELATION);
    }

    public void setRelation(String relation) {
        this.set(DC_RELATION, relation);
    }

    public String getRights() {
        return (String)this.get(DC_RIGHTS);
    }

    public void setRights(String rights) {
        this.set(DC_RIGHTS, rights);
    }

    public String getSource() {
        return (String)this.get(DC_SOURCE);
    }

    public void setSource(String source) {
        this.set(DC_SOURCE, source);
    }

    public void beforeSave() {
        super.beforeSave();
        if (this.get(DC_LANGUAGE) == null) {
            this.set(DC_LANGUAGE, this.getOwner().getLanguage());
        }
    }

    public void setKeywords(String keywords) {
        this.set(DC_KEYWORDS, keywords);
    }

    public String getKeywords() {
        return (String)this.get(DC_KEYWORDS);
    }

    static {
        logger.debug((Object)"Static initalizer starting...");
        s_config.load();
        logger.debug((Object)"Static initalizer finished.");
    }
}

