/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.cms.dublin.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.DateTime;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.parameters.DateTimeParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringLengthValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.parameters.TrimmedStringParameter;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.london.cms.dublin.DublinCoreItem;
import com.arsdigita.london.cms.dublin.ui.ControlledList;
import com.arsdigita.london.cms.dublin.ui.KeywordsValidationListener;
import com.arsdigita.london.terms.Domain;
import java.util.Date;
import org.apache.log4j.Logger;

public abstract class DublinCoreFormSection
extends FormSection
implements FormInitListener,
FormProcessListener {
    private static final Logger s_log = Logger.getLogger(DublinCoreFormSection.class);
    private Widget m_audience;
    private Widget m_ccn_portal_instance;
    private Widget m_coverageSpatial;
    private TextField m_coveragePostcode;
    private Widget m_coverageUnit;
    private DateTime m_temporalBegin;
    private DateTime m_temporalEnd;
    private TextArea m_creatorOwner;
    private TextField m_creatorContact;
    private TextArea m_description;
    private TextArea m_publisher;
    private TextArea m_rights;
    private TextField m_coverageSpatialRef;
    private TextField m_dateValid;
    private TextField m_disposalReview;
    private TextField m_keywords;
    private boolean editableDescription;
    private Submit m_cancel;

    public DublinCoreFormSection(boolean editableDescription) {
        this.editableDescription = editableDescription;
        this.m_audience = this.createControlledList("audience", DublinCoreItem.getConfig().getAudienceDomain());
        this.m_coverageSpatial = this.createControlledList("coverageSpatial", DublinCoreItem.getConfig().getCoverageSpatialDomain());
        this.m_coverageUnit = this.createControlledList("coverageUnit", DublinCoreItem.getConfig().getCoverageUnitDomain());
        if (DublinCoreItem.getConfig().getUseCCNPortalMetadata()) {
            SingleSelect ss = new SingleSelect("ccnPortalInstance");
            ss.addOption(new Option("", "(none)"));
            ss.addOption(new Option("browse", "Browse"));
            this.m_ccn_portal_instance = ss;
        }
        this.m_coveragePostcode = new TextField((ParameterModel)new StringParameter("coveragePostcode"));
        this.m_coveragePostcode.addValidationListener((ParameterListener)new StringLengthValidationListener(20));
        this.m_coveragePostcode.setSize(10);
        this.m_coverageSpatialRef = new TextField((ParameterModel)new StringParameter("coverageSpatialRef"));
        this.m_coverageSpatialRef.addValidationListener((ParameterListener)new StringLengthValidationListener(20));
        this.m_coverageSpatialRef.setSize(10);
        this.m_temporalBegin = new DateTime((ParameterModel)new DateTimeParameter("temporalBegin"));
        this.m_temporalEnd = new DateTime((ParameterModel)new DateTimeParameter("temporalEnd"));
        this.m_dateValid = new TextField((ParameterModel)new StringParameter("dateValid"));
        this.m_dateValid.addValidationListener((ParameterListener)new StringLengthValidationListener(100));
        this.m_disposalReview = new TextField((ParameterModel)new StringParameter("disposalReview"));
        this.m_disposalReview.addValidationListener((ParameterListener)new StringLengthValidationListener(100));
        this.m_creatorOwner = new TextArea((ParameterModel)new StringParameter("creatorOwner"));
        this.m_creatorOwner.addValidationListener((ParameterListener)new StringLengthValidationListener(300));
        this.m_creatorOwner.setCols(50);
        this.m_creatorOwner.setRows(3);
        this.m_creatorContact = new TextField((ParameterModel)new StringParameter("creatorContact"));
        this.m_creatorContact.addValidationListener((ParameterListener)new StringLengthValidationListener(120));
        this.m_creatorContact.setSize(50);
        this.m_description = new TextArea((ParameterModel)new StringParameter("description"));
        if (editableDescription) {
            this.m_description.addValidationListener((ParameterListener)new StringLengthValidationListener(4000));
            this.m_description.setCols(50);
            this.m_description.setRows(10);
        } else {
            this.m_description.setReadOnly();
        }
        this.m_publisher = new TextArea((ParameterModel)new StringParameter("publisher"));
        this.m_publisher.addValidationListener((ParameterListener)new StringLengthValidationListener(4000));
        this.m_publisher.setCols(50);
        this.m_publisher.setRows(5);
        this.m_rights = new TextArea((ParameterModel)new StringParameter("rights"));
        this.m_rights.addValidationListener((ParameterListener)new StringLengthValidationListener(4000));
        this.m_rights.setCols(50);
        this.m_rights.setRows(10);
        this.m_keywords = new TextField((ParameterModel)new TrimmedStringParameter("keywords"));
        this.m_keywords.addValidationListener((ParameterListener)new StringLengthValidationListener(4000));
        this.m_keywords.addValidationListener((ParameterListener)new KeywordsValidationListener());
        this.m_keywords.setHint("Enter a list of keywords, separated with commas");
        this.m_keywords.setSize(50);
        this.add((Component)new Label("Audience:", "b"), 4);
        this.add((Component)this.m_audience);
        this.add((Component)new Label("Coverage:", "b"), 4);
        this.add((Component)this.m_coverageSpatial);
        this.add((Component)new Label("Coverage (postcode):", "b"), 4);
        this.add((Component)this.m_coveragePostcode);
        this.add((Component)new Label("Coverage (spatial reference number):", "b"), 4);
        this.add((Component)this.m_coverageSpatialRef);
        this.add((Component)new Label("Coverage (unit):", "b"), 4);
        this.add((Component)this.m_coverageUnit);
        this.add((Component)new Label("Coverage (temporal begin):", "b"), 4);
        this.add((Component)this.m_temporalBegin);
        this.add((Component)new Label("Coverage (temporal end):", "b"), 4);
        this.add((Component)this.m_temporalEnd);
        this.add((Component)new Label("Date (valid):", "b"), 4);
        this.add((Component)this.m_dateValid);
        this.add((Component)new Label("Disposal Review", "b"), 4);
        this.add((Component)this.m_disposalReview);
        this.add((Component)new Label("Creator (owner):", "b"), 4);
        this.add((Component)this.m_creatorOwner);
        this.add((Component)new Label("Creator (contact):", "b"), 4);
        this.add((Component)this.m_creatorContact);
        this.add((Component)new Label("Description:", "b"), 4);
        this.add((Component)this.m_description);
        this.add((Component)new Label("Publisher:", "b"), 4);
        this.add((Component)this.m_publisher);
        this.add((Component)new Label("Rights:", "b"), 4);
        this.add((Component)this.m_rights);
        this.add((Component)new Label("Keywords:", "b"), 4);
        this.add((Component)this.m_keywords);
        if (DublinCoreItem.getConfig().getUseCCNPortalMetadata()) {
            this.add((Component)new Label("Include page in portal:", "b"), 4);
            this.add((Component)this.m_ccn_portal_instance);
        }
        SaveCancelSection saveCancel = new SaveCancelSection();
        this.m_cancel = saveCancel.getCancelButton();
        this.add((Component)saveCancel, 64);
        this.addInitListener(this);
        this.addProcessListener(this);
    }

    public Submit getCancelButton() {
        return this.m_cancel;
    }

    protected Widget createControlledList(String name, String key) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Creating controlled list with " + name + " key " + key));
        }
        Domain domain = null;
        if (key != null) {
            try {
                domain = Domain.retrieve((String)key);
            }
            catch (DataObjectNotFoundException ex) {
                s_log.warn((Object)("Cannot find controlled list key " + key + " for field " + name));
            }
        }
        if (domain == null) {
            TextField widget = new TextField(name);
            widget.setSize(40);
            return widget;
        }
        ControlledList widget = new ControlledList(name, domain);
        return widget;
    }

    private String getDefaultCreatorContact(Party party) {
        if (DublinCoreItem.getConfig().getOwnerContactDefault() != null) {
            return DublinCoreItem.getConfig().getOwnerContactDefault();
        }
        return party.getPrimaryEmail().toString();
    }

    public void init(FormSectionEvent fse) throws FormProcessException {
        PageState state = fse.getPageState();
        ContentItem item = this.getSelectedItem(state);
        if (item == null) {
            return;
        }
        DublinCoreItem dcItem = DublinCoreItem.findByOwner(item);
        if (dcItem == null) {
            this.m_creatorOwner.setValue(state, (Object)DublinCoreItem.getConfig().getOwnerDefault());
            Party party = Kernel.getContext().getParty();
            this.m_creatorContact.setValue(state, (Object)this.getDefaultCreatorContact(party));
            this.m_publisher.setValue(state, (Object)DublinCoreItem.getConfig().getPublisherDefault());
            this.m_rights.setValue(state, (Object)DublinCoreItem.getConfig().getRightsDefault());
            this.m_description.setValue(state, (Object)this.getInitialDescription(item));
            return;
        }
        this.m_audience.setValue(state, (Object)dcItem.getAudience());
        this.m_coverageSpatial.setValue(state, (Object)dcItem.getCoverage());
        this.m_coveragePostcode.setValue(state, (Object)dcItem.getCoveragePostcode());
        this.m_coverageSpatialRef.setValue(state, (Object)dcItem.getCoverageSpatialRef());
        this.m_coverageUnit.setValue(state, (Object)dcItem.getCoverageUnit());
        this.m_temporalBegin.setValue(state, (Object)dcItem.getTemporalBegin());
        this.m_temporalEnd.setValue(state, (Object)dcItem.getTemporalEnd());
        this.m_dateValid.setValue(state, (Object)dcItem.getDateValid());
        this.m_disposalReview.setValue(state, (Object)dcItem.getDisposalReview());
        this.m_creatorOwner.setValue(state, (Object)(dcItem.getCreatorOwner() == null ? DublinCoreItem.getConfig().getOwnerDefault() : dcItem.getCreatorOwner()));
        Party party = Kernel.getContext().getParty();
        this.m_creatorContact.setValue(state, (Object)(dcItem.getCreatorContact() == null ? this.getDefaultCreatorContact(party) : dcItem.getCreatorContact()));
        this.m_publisher.setValue(state, (Object)(dcItem.getPublisher() == null ? DublinCoreItem.getConfig().getPublisherDefault() : dcItem.getPublisher()));
        this.m_rights.setValue(state, (Object)(dcItem.getRights() == null ? DublinCoreItem.getConfig().getRightsDefault() : dcItem.getRights()));
        this.m_keywords.setValue(state, (Object)dcItem.getKeywords());
        if (this.editableDescription) {
            this.m_description.setValue(state, (Object)dcItem.getDescription());
        } else {
            this.m_description.setValue(state, (Object)this.getInitialDescription(item));
        }
        if (DublinCoreItem.getConfig().getUseCCNPortalMetadata()) {
            this.m_ccn_portal_instance.setValue(state, (Object)dcItem.getCcnPortalInstance());
        }
    }

    public void process(FormSectionEvent fse) throws FormProcessException {
        PageState state = fse.getPageState();
        ContentItem item = this.getSelectedItem(state);
        if (item == null) {
            return;
        }
        DublinCoreItem dcItem = DublinCoreItem.findByOwner(item);
        if (dcItem == null) {
            dcItem = DublinCoreItem.create(item);
        }
        dcItem.setAudience((String)this.m_audience.getValue(state));
        dcItem.setCoverage((String)this.m_coverageSpatial.getValue(state));
        dcItem.setCoveragePostcode((String)this.m_coveragePostcode.getValue(state));
        dcItem.setCoverageSpatialRef((String)this.m_coverageSpatialRef.getValue(state));
        dcItem.setCoverageUnit((String)this.m_coverageUnit.getValue(state));
        dcItem.setTemporalBegin((Date)this.m_temporalBegin.getValue(state));
        dcItem.setTemporalEnd((Date)this.m_temporalEnd.getValue(state));
        dcItem.setDateValid((String)this.m_dateValid.getValue(state));
        dcItem.setDisposalReview((String)this.m_disposalReview.getValue(state));
        dcItem.setCreatorOwner((String)this.m_creatorOwner.getValue(state));
        dcItem.setCreatorContact((String)this.m_creatorContact.getValue(state));
        dcItem.setPublisher((String)this.m_publisher.getValue(state));
        dcItem.setRights((String)this.m_rights.getValue(state));
        dcItem.setKeywords((String)this.m_keywords.getValue(state));
        if (this.editableDescription) {
            this.saveDescription((String)this.m_description.getValue(state), item, dcItem);
        }
        if (DublinCoreItem.getConfig().getUseCCNPortalMetadata()) {
            dcItem.setCcnPortalInstance((String)this.m_ccn_portal_instance.getValue(state));
        }
        dcItem.save();
    }

    protected abstract ContentItem getSelectedItem(PageState var1);

    protected String getInitialDescription(ContentItem item) {
        return "";
    }

    protected void saveDescription(String description, ContentItem item, DublinCoreItem dcItem) {
        dcItem.setDescription(description);
    }
}

