/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.london.cms.dublin.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.category.CategoryIteratorListModel;
import com.arsdigita.london.cms.dublin.DublinCoreItem;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.xml.Element;
import java.text.DateFormat;
import java.util.Date;
import org.apache.log4j.Category;

public class DublinCoreSummary
extends ColumnPanel {
    private static final Category s_log = Category.getInstance(DublinCoreSummary.class);
    private Label m_title;
    private Label m_audience;
    private Label m_coverage_spatial;
    private Label m_coverage_postcode;
    private Label m_coverage_unit;
    private Label m_date_created;
    private Label m_date_issued;
    private Label m_date_modified;
    private Label m_dateValid;
    private Label m_temporal_begin;
    private Label m_temporal_end;
    private Label m_creator_owner;
    private Label m_creator_contact;
    private Label m_description;
    private Label m_publisher;
    private Label m_rights;
    private Label m_documentType;
    private Label m_disposalReview;
    private Label m_language;
    private Label m_coverageSpatialRef;
    private List m_categories;
    private List m_interaction;
    private Label m_keywords;
    private Label m_ccn_portal_instance;
    private ItemSelectionModel m_itemModel;

    public DublinCoreSummary(ItemSelectionModel itemModel) {
        super(2);
        this.setColumnWidth(1, "40%");
        this.m_itemModel = itemModel;
        this.m_title = new Label();
        this.m_audience = new Label();
        this.m_coverage_spatial = new Label();
        this.m_coverageSpatialRef = new Label();
        this.m_coverage_postcode = new Label();
        this.m_coverage_unit = new Label();
        this.m_date_created = new Label();
        this.m_date_issued = new Label();
        this.m_date_modified = new Label();
        this.m_temporal_begin = new Label();
        this.m_temporal_end = new Label();
        this.m_dateValid = new Label();
        this.m_disposalReview = new Label();
        this.m_documentType = new Label();
        this.m_creator_owner = new Label();
        this.m_creator_contact = new Label();
        this.m_description = new Label();
        this.m_publisher = new Label();
        this.m_rights = new Label();
        this.m_language = new Label();
        this.m_keywords = new Label();
        SimpleCellRenderer simpleCellRenderer = new SimpleCellRenderer();
        this.m_categories = new List((ListModelBuilder)new CategoryListModelBuilder(itemModel, "subject"));
        this.m_categories.setCellRenderer((ListCellRenderer)simpleCellRenderer);
        this.m_interaction = new List((ListModelBuilder)new CategoryListModelBuilder(itemModel, "interaction"));
        this.m_interaction.setCellRenderer((ListCellRenderer)simpleCellRenderer);
        if (DublinCoreItem.getConfig().getUseCCNPortalMetadata()) {
            this.m_ccn_portal_instance = new Label();
        }
        this.add((Component)new Label("Title:", "b"), 4);
        this.add((Component)this.m_title);
        this.add((Component)new Label("Audience:", "b"), 4);
        this.add((Component)this.m_audience);
        this.add((Component)new Label("Coverage:", "b"), 4);
        this.add((Component)this.m_coverage_spatial);
        this.add((Component)new Label("Coverage (postcode):", "b"), 4);
        this.add((Component)this.m_coverage_postcode);
        this.add((Component)new Label("Coverage (spatial reference number):", "b"), 4);
        this.add((Component)this.m_coverageSpatialRef);
        this.add((Component)new Label("Coverage (unit):", "b"), 4);
        this.add((Component)this.m_coverage_unit);
        this.add((Component)new Label("Coverage (temporal begin):", "b"), 4);
        this.add((Component)this.m_temporal_begin);
        this.add((Component)new Label("Coverage (temporal end):", "b"), 4);
        this.add((Component)this.m_temporal_end);
        this.add((Component)new Label("Creator (owner):", "b"), 4);
        this.add((Component)this.m_creator_owner);
        this.add((Component)new Label("Creator (contact):", "b"), 4);
        this.add((Component)this.m_creator_contact);
        this.add((Component)new Label("Date (created):", "b"), 4);
        this.add((Component)this.m_date_created);
        this.add((Component)new Label("Date (issued):", "b"), 4);
        this.add((Component)this.m_date_issued);
        this.add((Component)new Label("Date (modified):", "b"), 4);
        this.add((Component)this.m_date_modified);
        this.add((Component)new Label("Date (valid):", "b"), 4);
        this.add((Component)this.m_dateValid);
        this.add((Component)new Label("Description:", "b"), 4);
        this.add((Component)this.m_description);
        this.add((Component)new Label("Publisher:", "b"), 4);
        this.add((Component)this.m_publisher);
        this.add((Component)new Label("Rights:", "b"), 4);
        this.add((Component)this.m_rights);
        this.add((Component)new Label("Type (document type):", "b"), 4);
        this.add((Component)this.m_documentType);
        this.add((Component)new Label("Disposal (review):", "b"), 4);
        this.add((Component)this.m_disposalReview);
        this.add((Component)new Label("Language:", "b"), 4);
        this.add((Component)this.m_language);
        this.add((Component)new Label("Keywords:", "b"), 4);
        this.add((Component)this.m_keywords);
        this.add((Component)new Label("Subject Categories:", "b"), 12);
        this.add((Component)this.m_categories);
        this.add((Component)new Label("Interaction:", "b"), 12);
        this.add((Component)this.m_interaction);
        if (DublinCoreItem.getConfig().getUseCCNPortalMetadata()) {
            this.add((Component)new Label("Include page in portal:", "b"), 4);
            this.add((Component)this.m_ccn_portal_instance);
        }
    }

    public void generateXML(PageState state, Element parent) {
        String issueDate;
        ContentPage latest;
        ContentPage item = (ContentPage)this.m_itemModel.getSelectedObject(state);
        DublinCoreItem dcItem = DublinCoreItem.findByOwner((ContentItem)item);
        this.m_title.setLabel(item.getDisplayName(), state);
        if (dcItem != null) {
            this.m_audience.setLabel(dcItem.getAudience(), state);
            this.m_coverage_spatial.setLabel(dcItem.getCoverage(), state);
            this.m_coverage_postcode.setLabel(dcItem.getCoveragePostcode(), state);
            this.m_coverageSpatialRef.setLabel(dcItem.getCoverageSpatialRef(), state);
            this.m_coverage_unit.setLabel(dcItem.getCoverageUnit(), state);
            if (DublinCoreItem.getConfig().getUseCCNPortalMetadata()) {
                this.m_ccn_portal_instance.setLabel(dcItem.getCcnPortalInstance(), state);
            }
        }
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
        if (item.isLive()) {
            latest = (ContentPage)item.getLiveVersion();
            Date issued = item.getLifecycle().getStartDate();
            issueDate = issued != null ? dateFormat.format(issued) : "";
        } else {
            latest = item;
            issueDate = "";
        }
        String creationDate = item.getCreationDate() != null ? dateFormat.format(item.getCreationDate()) : "";
        String modifiedDate = latest.getLastModifiedDate() != null ? dateFormat.format(latest.getLastModifiedDate()) : "";
        this.m_date_created.setLabel(creationDate, state);
        this.m_date_issued.setLabel(issueDate, state);
        this.m_date_modified.setLabel(modifiedDate, state);
        if (dcItem != null) {
            this.m_temporal_begin.setLabel(dcItem.getTemporalBegin() == null ? null : dateFormat.format(dcItem.getTemporalBegin()), state);
            this.m_temporal_end.setLabel(dcItem.getTemporalEnd() == null ? null : dateFormat.format(dcItem.getTemporalEnd()), state);
            this.m_creator_owner.setLabel(dcItem.getCreatorOwner(), state);
            this.m_creator_contact.setLabel(dcItem.getCreatorContact(), state);
        }
        this.m_description.setLabel(item.getSearchSummary(), state);
        if (dcItem != null) {
            this.m_publisher.setLabel(dcItem.getPublisher(), state);
            this.m_rights.setLabel(dcItem.getRights(), state);
        }
        this.m_documentType.setLabel(item.getContentType().getLabel(), state);
        this.m_language.setLabel(item.getLanguage(), state);
        if (dcItem != null) {
            this.m_dateValid.setLabel(dcItem.getDateValid(), state);
            this.m_disposalReview.setLabel(dcItem.getDisposalReview(), state);
            this.m_keywords.setLabel(dcItem.getKeywords(), state);
        }
        super.generateXML(state, parent);
    }

    protected class SimpleCellRenderer
    implements ListCellRenderer {
        protected SimpleCellRenderer() {
        }

        public Component getComponent(List list, PageState state, Object value, String key, int index, boolean isSelected) {
            return new Label(value.toString());
        }
    }

    protected class CategoryListModelBuilder
    extends LockableImpl
    implements ListModelBuilder {
        private ItemSelectionModel m_itemModel;
        private String m_context;

        public CategoryListModelBuilder(ItemSelectionModel itemModel, String context) {
            this.m_itemModel = itemModel;
            this.m_context = context;
        }

        public ListModel makeModel(List l, PageState state) {
            ContentPage item = (ContentPage)this.m_itemModel.getSelectedObject(state);
            return new CategoryIteratorListModel(item.getCategories(this.m_context));
        }
    }
}

