/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.portalserver.PortalSite;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class Role
extends Group {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/Role.java#6 $";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.workspace.Role";
    public static final String MEMBER_TYPE = "members";
    private static final Logger s_log = Logger.getLogger(Role.class);
    private PortalSite m_portalsite;

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public Role(DataObject obj) {
        super(obj);
    }

    public Role(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Role(BigDecimal id) throws DataObjectNotFoundException {
        super(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    protected Role(PortalSite psite, String roleName, String assigneeTitle, String description, boolean isSystem) {
        super(BASE_DATA_OBJECT_TYPE);
        this.setPortalSite(psite);
        this.setSystem(isSystem);
        this.setRoleNameInternal(roleName);
        this.setAssigneeTitleInternal(assigneeTitle);
        this.setDescriptionInternal(description);
    }

    public static Role createRole(PortalSite psite, String roleName, String assigneeTitle, String description) {
        return Role.createRole(psite, roleName, assigneeTitle, description, false);
    }

    public static Role createRole(PortalSite psite, String roleName, String assigneeTitle, String description, boolean isSystem) {
        return new Role(psite, roleName, assigneeTitle, description, isSystem);
    }

    public static Role createRole(PortalSite psite, String roleName, String assigneeTitle, String description, boolean isSystem, String roleType) {
        Role role = new Role(psite, roleName, assigneeTitle, description, isSystem);
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)"creating role ", new Throwable());
        }
        role.setRoleTypeInternal(roleType);
        return role;
    }

    public String getRoleName() {
        return (String)this.get("roleName");
    }

    public void setRoleName(String roleName) {
        this.systemCheck();
        this.setRoleNameInternal(roleName);
    }

    private void setRoleNameInternal(String roleName) {
        this.set("roleName", roleName);
        this.setName(this.getPortalSite().getTitle() + ": " + roleName);
    }

    public String getAssigneeTitle() {
        return (String)this.get("assigneeTitle");
    }

    public void setAssigneeTitle(String title) {
        this.systemCheck();
        this.setAssigneeTitleInternal(title);
    }

    private void setAssigneeTitleInternal(String title) {
        this.set("assigneeTitle", title);
    }

    public String getDescription() {
        return (String)this.get("description");
    }

    public void setDescription(String description) {
        this.systemCheck();
        this.setDescriptionInternal(description);
    }

    private void setDescriptionInternal(String description) {
        this.set("description", description);
    }

    private void setRoleTypeInternal(String type) {
        this.set("type", type);
    }

    public PortalSite getPortalSite() {
        if (this.m_portalsite == null) {
            this.m_portalsite = (PortalSite)DomainObjectFactory.newInstance((DataObject)((DataObject)this.get("workspace")));
        }
        return this.m_portalsite;
    }

    private void setPortalSite(PortalSite portalsite) {
        this.setAssociation("workspace", (DomainObject)portalsite);
        this.m_portalsite = portalsite;
    }

    private void setSystem(boolean isSystem) {
        this.set("isSystem", isSystem ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isSystem() {
        return Boolean.TRUE.equals(this.get("isSystem"));
    }

    private void systemCheck() {
        if (this.isSystem()) {
            throw new RuntimeException("Can not modify system roles.");
        }
    }

    public void delete() {
        if (this.isSystem()) {
            throw new RuntimeException("Can't delete system roles");
        }
        this.clearMembers();
        this.clearSubgroups();
        PermissionService.revokePartyPermissions((OID)this.getOID());
        super.delete();
    }

    protected void afterSave() {
        PermissionService.setContext((ACSObject)this, (ACSObject)this.m_portalsite);
        super.afterSave();
    }
}

