/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver;

import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.portalserver.ThemeCollection;
import com.arsdigita.portalserver.Themes;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;

public class Theme
extends ACSObject
implements Themes {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.workspace.Theme";

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public Theme(DataObject dataObject) {
        super(dataObject);
    }

    public Theme(String name) {
        super(BASE_DATA_OBJECT_TYPE);
        this.setName(name);
        this.setContextBarColor("#006600");
        this.setContextBarColor("#000000");
        this.setActiveTabColor("#550000");
        this.setInactiveTabColor("#000055");
        this.setActiveTabTextColor("#000000");
        this.setInactiveTabTextColor("#000000");
        this.setTopRuleColor("#770033");
        this.setBottomRuleColor("#770033");
        this.setPortletHeaderColor("#440500");
        this.setPortletIconColor("#440500");
        this.setPortletBorderColor("#000048");
        this.setPortletBorderStyle("solid");
        this.setPortletHeaderTextColor("#000000");
        this.setPageBGColor("#ffffff");
        this.setPageBGImage("");
        this.setNarrowBGColor("#ffffff");
        this.setBodyTextColor("#000000");
    }

    public static Theme retrieveTheme(BigDecimal themeID) {
        Assert.exists((Object)themeID);
        return Theme.retrieveTheme(new OID(BASE_DATA_OBJECT_TYPE, (Object)themeID));
    }

    public static Theme retrieveTheme(DataObject dataObject) {
        Assert.exists((Object)dataObject);
        return new Theme(dataObject);
    }

    public static Theme retrieveTheme(OID oid) {
        Assert.exists((Object)oid);
        DataObject dataObject = SessionManager.getSession().retrieve(oid);
        return Theme.retrieveTheme(dataObject);
    }

    public static ThemeCollection retrieveAllThemes() {
        DataCollection dataCollection = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        ThemeCollection themeCollection = new ThemeCollection(dataCollection);
        return themeCollection;
    }

    public String getName() {
        String name = (String)this.get("theme_name");
        Assert.exists((Object)name);
        return name;
    }

    public void setName(String name) {
        Assert.exists((Object)name);
        this.set("theme_name", name);
    }

    public String getDescription() {
        String description = (String)this.get("theme_desc");
        Assert.exists((Object)description);
        return description;
    }

    public void setDescription(String desc) {
        this.set("theme_desc", desc);
    }

    public void setContextBarColor(String color) {
        this.set("ctx_bar_color", color);
    }

    public String getContextBarColor() {
        String cbc = (String)this.get("ctx_bar_color");
        return cbc;
    }

    public void setContextBarTextColor(String color) {
        this.set("ctx_bar_text_color", color);
    }

    public String getContextBarTextColor() {
        String cbtc = (String)this.get("ctx_bar_text_color");
        return cbtc;
    }

    public void setActiveTabColor(String color) {
        this.set("active_tab_color", color);
    }

    public String getActiveTabColor() {
        String atc = (String)this.get("active_tab_color");
        return atc;
    }

    public void setInactiveTabColor(String color) {
        this.set("inactive_tab_color", color);
    }

    public String getInactiveTabColor() {
        String itc = (String)this.get("inactive_tab_color");
        return itc;
    }

    public void setActiveTabTextColor(String color) {
        this.set("active_tab_text_color", color);
    }

    public String getActiveTabTextColor() {
        String attc = (String)this.get("active_tab_text_color");
        return attc;
    }

    public void setInactiveTabTextColor(String color) {
        this.set("inactive_tab_text_color", color);
    }

    public String getInactiveTabTextColor() {
        String ittc = (String)this.get("inactive_tab_text_color");
        return ittc;
    }

    public void setTopRuleColor(String color) {
        this.set("top_rule", color);
    }

    public String getTopRuleColor() {
        String trc = (String)this.get("top_rule");
        return trc;
    }

    public void setBottomRuleColor(String color) {
        this.set("bottom_rule", color);
    }

    public String getBottomRuleColor() {
        String brc = (String)this.get("bottom_rule");
        return brc;
    }

    public void setPortletHeaderColor(String color) {
        this.set("portlet_head", color);
    }

    public String getPortletHeaderColor() {
        String phc = (String)this.get("portlet_head");
        return phc;
    }

    public void setPortletIconColor(String color) {
        this.set("portlet_icon", color);
    }

    public String getPortletIconColor() {
        String pic = (String)this.get("portlet_icon");
        return pic;
    }

    public void setPortletBorderColor(String color) {
        this.set("portlet_border_color", color);
    }

    public String getPortletBorderColor() {
        String pbc = (String)this.get("portlet_border_color");
        return pbc;
    }

    public void setPortletBorderStyle(String style) {
        this.set("portlet_border_style", style);
    }

    public String getPortletBorderStyle() {
        String pbs = (String)this.get("portlet_border_style");
        return pbs;
    }

    public void setPortletHeaderTextColor(String color) {
        this.set("portlet_header_text_color", color);
    }

    public String getPortletHeaderTextColor() {
        String phtc = (String)this.get("portlet_header_text_color");
        return phtc;
    }

    public void setPageBGColor(String color) {
        this.set("page_bg_color", color);
    }

    public String getPageBGColor() {
        String pbgc = (String)this.get("page_bg_color");
        return pbgc;
    }

    public void setPageBGImage(String url) {
        this.set("page_bg_image", url);
    }

    public String getPageBGImage() {
        String pbgi = (String)this.get("page_bg_image");
        return pbgi;
    }

    public void setNarrowBGColor(String color) {
        this.set("narrow_bg_color", color);
    }

    public String getNarrowBGColor() {
        String nbc = (String)this.get("narrow_bg_color");
        return nbc;
    }

    public void setBodyTextColor(String color) {
        this.set("body_text_color", color);
    }

    public String getBodyTextColor() {
        String btc = (String)this.get("body_text_color");
        return btc;
    }

    protected void afterSave() {
        super.afterSave();
    }

    @Override
    public StringBuffer buildStyleBlock() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<STYLE type=\"text/css\"> <!--");
        buffer.append(" table.globalHeader { background-color: " + this.getContextBarColor() + ";} ");
        buffer.append(" table.globalHeader { color: " + this.getContextBarTextColor() + ";} ");
        buffer.append(" table.tabs td.activeTab { background: " + this.getActiveTabColor() + ";} ");
        buffer.append(" table.tabs td.tabBeginning { background: " + this.getActiveTabColor() + ";} ");
        buffer.append(" table.tabs td.tabEnd { background: " + this.getActiveTabColor() + ";} ");
        buffer.append(" table.tabs td.inactiveTab { background: " + this.getInactiveTabColor() + ";} ");
        buffer.append(" table.tabs td.tabBeginningOff { background: " + this.getInactiveTabColor() + ";} ");
        buffer.append(" table.tabs td.tabEndOff { background: " + this.getInactiveTabColor() + ";} ");
        buffer.append(" table.tabs td.activeTab { color: " + this.getActiveTabTextColor() + ";} ");
        buffer.append(" table.tabs td.inactiveTab { color: " + this.getInactiveTabTextColor() + ";} ");
        buffer.append(" table.topRuleUnderTabs { background: " + this.getTopRuleColor() + ";} ");
        buffer.append(" table.topRuleNoTabs { background: " + this.getTopRuleColor() + ";} ");
        buffer.append(" table.bottomRule { background: " + this.getBottomRuleColor() + ";} ");
        buffer.append(" table.portlet td.portletHeader { background: " + this.getPortletHeaderColor() + ";} ");
        buffer.append(" table.portlet td.portletIcon { background: " + this.getPortletIconColor() + ";} ");
        buffer.append(" table.portlet td.portletHeader { color: " + this.getPortletHeaderTextColor() + ";} ");
        buffer.append(" body { background: " + this.getPageBGColor() + ";} ");
        if (this.getPageBGImage() != null) {
            buffer.append(" body {background-image: url(" + this.getPageBGImage() + ");} ");
        }
        buffer.append(" td.narrowColumn td.portletBody { background: " + this.getNarrowBGColor() + ";} ");
        buffer.append(" td.narrowColumnLeft td.portletBody { background: " + this.getNarrowBGColor() + ";} ");
        buffer.append(" td.narrowColumnRight td.portletBody { background: " + this.getNarrowBGColor() + ";} ");
        buffer.append("--></STYLE>");
        return buffer;
    }
}

