/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.permissions;

import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.OID;
import com.arsdigita.portalserver.permissions.Grant;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

class AddGrantForm
extends Form {
    static final String ALL_TYPES = "ALL_TYPES";
    private BigDecimalParameter m_objectParameter;
    private BigDecimalParameter m_partyParameter;
    private StringParameter m_privilegeParameter;
    private StringParameter m_typeParameter;
    private RequestLocal m_errorMessageRL;
    private RequestLocal m_grantPermissionRL;
    private static final Logger s_log = Logger.getLogger(AddGrantForm.class);

    BigDecimalParameter getObjectParameter() {
        return this.m_objectParameter;
    }

    BigDecimalParameter getPartyParameter() {
        return this.m_partyParameter;
    }

    StringParameter getPrivilegeParameter() {
        return this.m_privilegeParameter;
    }

    StringParameter getTypeParameter() {
        return this.m_typeParameter;
    }

    AddGrantForm(String name, Container container, RequestLocal errorMessageRL) {
        super(name, container);
        this.setRedirecting(true);
        this.forwardValidation();
        this.forwardProcess();
        this.m_objectParameter = new BigDecimalParameter("objectID");
        this.m_partyParameter = new BigDecimalParameter("partyID");
        this.m_privilegeParameter = new StringParameter("privName");
        this.m_typeParameter = new StringParameter("typeName");
        this.m_errorMessageRL = errorMessageRL;
        this.m_grantPermissionRL = new RequestLocal();
    }

    protected void fireValidate(FormSectionEvent ev) {
        s_log.debug((Object)"AddGrantForm.fireValidate running");
        PageState ps = ev.getPageState();
        FormData fd = ev.getFormData();
        BigDecimal objectID = (BigDecimal)fd.get((Object)this.m_objectParameter.getName());
        BigDecimal partyID = (BigDecimal)fd.get((Object)this.m_partyParameter.getName());
        String typeName = (String)fd.get((Object)this.m_typeParameter.getName());
        String privName = (String)fd.get((Object)this.m_privilegeParameter.getName());
        OID partyOID = new OID("com.arsdigita.kernel.Party", (Object)partyID);
        OID objectOID = new OID("com.arsdigita.kernel.ACSObject", (Object)objectID);
        PrivilegeDescriptor testPriv = Grant.s_interestingPrivileges[0];
        PrivilegeDescriptor newPriv = PrivilegeDescriptor.get((String)privName);
        PermissionDescriptor testPerm = new PermissionDescriptor(testPriv, objectOID, partyOID);
        if (PermissionService.checkDirectPermission((PermissionDescriptor)testPerm)) {
            String objectName;
            String partyName;
            try {
                Party party = (Party)DomainObjectFactory.newInstance((OID)partyOID);
                partyName = party.getName();
            }
            catch (DataObjectNotFoundException ex) {
                throw new IllegalStateException("Bad Party");
            }
            try {
                ACSObject object = (ACSObject)DomainObjectFactory.newInstance((OID)objectOID);
                objectName = object.getDisplayName();
            }
            catch (DataObjectNotFoundException ex) {
                throw new IllegalStateException("Bad Object");
            }
            String errMsg = typeName == null ? "\"" + partyName + "\"" + " already has a defined right " + "on \"" + objectName + "\"." : (typeName.equals(ALL_TYPES) ? "\"" + partyName + "\" already has a defined right on \"" + objectName + "\" and its contents." : "\"" + partyName + "\" already has a defined right on " + "the " + typeName + "s contained in \"" + objectName + "\".");
            this.m_errorMessageRL.set(ps, (Object)errMsg);
            fd.addError(errMsg);
        } else {
            PermissionDescriptor perm = new PermissionDescriptor(newPriv, objectOID, partyOID);
            this.m_grantPermissionRL.set(ps, (Object)perm);
        }
        if (s_log.isDebugEnabled()) {
            if (fd.isValid()) {
                s_log.debug((Object)"VALID");
            } else {
                s_log.debug((Object)"INVALID");
            }
        }
        super.fireValidate(ev);
    }

    protected void fireProcess(FormSectionEvent ev) throws FormProcessException {
        PermissionDescriptor perm = (PermissionDescriptor)this.m_grantPermissionRL.get(ev.getPageState());
        PermissionService.grantPermission((PermissionDescriptor)perm);
        PrivilegeDescriptor pd = perm.getPrivilegeDescriptor();
        if (pd.equals((Object)PrivilegeDescriptor.EDIT) || pd.equals((Object)PrivilegeDescriptor.ADMIN)) {
            PermissionService.grantPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.CREATE, perm.getACSObjectOID(), perm.getPartyOID()));
        }
        super.fireProcess(ev);
    }
}

