/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.permissions;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.AbstractTableModelBuilder;
import com.arsdigita.bebop.table.DefaultTableColumnModel;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableHeader;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.OID;
import com.arsdigita.portalserver.Icons;
import com.arsdigita.portalserver.permissions.Grant;
import java.util.Iterator;
import org.apache.log4j.Category;

abstract class GrantsTable
extends Table {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/permissions/GrantsTable.java#4 $$Author: dennis $$DateTime: 2004/08/17 23:19:25 $";
    private static Category s_log = Category.getInstance((String)GrantsTable.class.getName());
    private static final String REMOVE_EVENT = "_revoke_all_";
    private static final String COLUMN_WIDTH = "12%";
    static final RequestLocal s_targetRL = new RequestLocal();
    static final RequestLocal s_adjustCodeRL = new RequestLocal();
    private static TableCellRenderer[] s_editCellRenderers;
    private static TableCellRenderer[] s_viewCellRenderers;
    private static final RequestLocal s_dynamicLabel;

    public GrantsTable(final RequestLocal grantsRL, final RequestLocal typesRL, boolean isEditable) {
        this.setClassAttr("fancy");
        this.setModelBuilder((TableModelBuilder)new AbstractTableModelBuilder(){

            public TableModel makeModel(Table t, PageState ps) {
                final Iterator grants = (Iterator)grantsRL.get(ps);
                return new TableModel(){
                    Grant m_currentGrant;
                    String m_currentKey;

                    public int getColumnCount() {
                        return 6;
                    }

                    public Object getElementAt(int index) {
                        return this.m_currentGrant;
                    }

                    public Object getKeyAt(int columnIndex) {
                        return this.m_currentKey;
                    }

                    public boolean nextRow() {
                        if (grants.hasNext()) {
                            this.m_currentGrant = (Grant)grants.next();
                            s_log.debug((Object)("Preparing to display Grant " + this.m_currentGrant));
                            this.m_currentKey = this.m_currentGrant.toString();
                            return true;
                        }
                        return false;
                    }
                };
            }
        });
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        TableColumn typeColumn = new TableColumn(1, "On"){

            public boolean isVisible(PageState ps) {
                return typesRL.get(ps) != null;
            }
        };
        typeColumn.setCellRenderer(new TableCellRenderer(){

            public Component getComponent(Table table, PageState ps, Object value, boolean isSelected, Object key, int row, int column) {
                Grant grant = (Grant)value;
                Label typeLabel = (Label)s_dynamicLabel.get(ps);
                typeLabel.setLabel(grant.objectTypeDisplayName);
                return typeLabel;
            }
        });
        columnModel.add(typeColumn);
        TableCellRenderer[] cellRenderers = isEditable ? s_editCellRenderers : s_viewCellRenderers;
        for (int i = 0; i < Grant.s_interestingPrivileges.length; ++i) {
            TableColumn privColumn = new TableColumn(2 + i, (Object)Grant.s_privilegePrettyNames[i]);
            privColumn.setCellRenderer(cellRenderers[i]);
            privColumn.setClassAttr("icon");
            privColumn.setHeadClassAttr("icon");
            privColumn.setWidth(COLUMN_WIDTH);
            columnModel.add(privColumn);
        }
        if (isEditable) {
            TableColumn removeColumn = new TableColumn(5, (Object)"Remove");
            removeColumn.setAlign("center");
            removeColumn.setCellRenderer(new TableCellRenderer(){
                final ControlLink m_link = new ControlLink((Component)Icons.TRASH_16){

                    public void setControlEvent(PageState ps) {
                        ps.setControlEvent((Component)GrantsTable.this, GrantsTable.REMOVE_EVENT, (String)s_adjustCodeRL.get(ps));
                    }
                };

                public Component getComponent(Table table, PageState ps, Object value, boolean isSelected, Object key, int row, int column) {
                    Grant grant = (Grant)value;
                    s_adjustCodeRL.set(ps, key);
                    return this.m_link;
                }
            });
            removeColumn.setClassAttr("icon");
            removeColumn.setHeadClassAttr("icon");
            removeColumn.setWidth(COLUMN_WIDTH);
            columnModel.add(removeColumn);
        }
        this.setColumnModel((TableColumnModel)columnModel);
        this.setHeader(new TableHeader((TableColumnModel)columnModel));
    }

    public void respond(PageState ps) {
        PrivilegeDescriptor newPriv;
        block9: {
            String controlEventName = ps.getControlEventName();
            String controlEventValue = ps.getControlEventValue();
            s_log.debug((Object)("Responding to control event \"" + controlEventName + " => " + controlEventValue + "\""));
            newPriv = null;
            if (!REMOVE_EVENT.equals(controlEventName)) {
                for (int i = 0; i < Grant.s_interestingPrivileges.length; ++i) {
                    PrivilegeDescriptor priv = Grant.s_interestingPrivileges[i];
                    String privName = priv.getName();
                    if (!privName.equals(controlEventName)) continue;
                    newPriv = priv;
                    break block9;
                }
                throw new IllegalStateException("Unknown control event");
            }
        }
        Grant grant = Grant.unmarshal(ps.getControlEventValue());
        OID objectOID = new OID("com.arsdigita.kernel.ACSObject", (Object)grant.objectID);
        OID partyOID = new OID("com.arsdigita.kernel.Party", (Object)grant.granteeID);
        s_log.debug((Object)("Privilege requested is " + newPriv + ". " + "Existing privilege is " + grant.basePrivilege + "."));
        int oldLevel = Grant.getPrivilegeLevel(grant.basePrivilege);
        if (oldLevel > 0 && newPriv == null) {
            s_log.debug((Object)("Revoking old privilege.  Old privilege was " + oldLevel + "."));
            PermissionDescriptor createPD = this.getPermissionDescriptorHelper(grant, 3, objectOID, partyOID);
            PermissionDescriptor oldPD = this.getPermissionDescriptorHelper(grant, oldLevel, objectOID, partyOID);
            PermissionService.revokePermission((PermissionDescriptor)createPD);
            PermissionService.revokePermission((PermissionDescriptor)oldPD);
        } else if (oldLevel == 0 && newPriv == null) {
            s_log.debug((Object)("Revoking old privilege.  Old privilege was " + oldLevel + "."));
            PermissionDescriptor oldPD = this.getPermissionDescriptorHelper(grant, oldLevel, objectOID, partyOID);
            PermissionService.revokePermission((PermissionDescriptor)oldPD);
        } else {
            s_log.debug((Object)"Adding new privilege, but first removing old ones.");
            int newLevel = Grant.getPrivilegeLevel(newPriv);
            PermissionDescriptor oldPD = this.getPermissionDescriptorHelper(grant, oldLevel, objectOID, partyOID);
            PermissionService.revokePermission((PermissionDescriptor)oldPD);
            PermissionDescriptor newPD = this.getPermissionDescriptorHelper(grant, newLevel, objectOID, partyOID);
            PermissionService.grantPermission((PermissionDescriptor)newPD);
            PermissionDescriptor createPD = this.getPermissionDescriptorHelper(grant, 3, objectOID, partyOID);
            if (newLevel == 1 || newLevel == 2) {
                s_log.debug((Object)"Implicitly granting create.");
                PermissionService.grantPermission((PermissionDescriptor)createPD);
            } else if (oldLevel == 1 || oldLevel == 2) {
                s_log.debug((Object)"Implicitly revoking create.");
                PermissionService.revokePermission((PermissionDescriptor)createPD);
            }
        }
    }

    private PermissionDescriptor getPermissionDescriptorHelper(Grant grant, int privLevel, OID objectOID, OID partyOID) {
        PrivilegeDescriptor priv = Grant.s_privileges[privLevel];
        return new PermissionDescriptor(priv, objectOID, partyOID);
    }

    static {
        int n = Grant.s_interestingPrivileges.length;
        s_editCellRenderers = new TableCellRenderer[n];
        s_viewCellRenderers = new TableCellRenderer[n];
        for (int i = 0; i < n; ++i) {
            GrantsTable.s_editCellRenderers[i] = new EditPrivilegeCellRenderer(Grant.s_interestingPrivileges[i]);
            GrantsTable.s_viewCellRenderers[i] = new ViewPrivilegeCellRenderer(Grant.s_interestingPrivileges[i]);
        }
        s_dynamicLabel = new RequestLocal(){

            public Object initialValue(PageState ps) {
                return new Label();
            }
        };
    }

    private static class ViewPrivilegeCellRenderer
    implements TableCellRenderer {
        final PrivilegeDescriptor m_privilege;

        ViewPrivilegeCellRenderer(PrivilegeDescriptor privilege) {
            this.m_privilege = privilege;
        }

        public Component getComponent(Table table, PageState ps, Object value, boolean isSelected, Object key, int row, int column) {
            Grant grant = (Grant)value;
            if (grant.basePrivilege.equals((Object)this.m_privilege)) {
                return Icons.RADIO_FULL_GRAYED_16;
            }
            return Icons.RADIO_EMPTY_GRAYED_16;
        }
    }

    private static class EditPrivilegeCellRenderer
    implements TableCellRenderer {
        final PrivilegeDescriptor m_privilege;
        final ControlLink m_link;

        EditPrivilegeCellRenderer(PrivilegeDescriptor privilege) {
            this.m_privilege = privilege;
            final String eventName = privilege.getName();
            this.m_link = new ControlLink((Component)Icons.RADIO_EMPTY_16){

                public void setControlEvent(PageState ps) {
                    ps.setControlEvent((Component)s_targetRL.get(ps), eventName, (String)s_adjustCodeRL.get(ps));
                }
            };
        }

        public Component getComponent(Table table, PageState ps, Object value, boolean isSelected, Object key, int row, int column) {
            Grant grant = (Grant)value;
            if (grant.basePrivilege.equals((Object)this.m_privilege)) {
                return Icons.RADIO_FULL_16;
            }
            s_targetRL.set(ps, (Object)table);
            s_adjustCodeRL.set(ps, key);
            return this.m_link;
        }
    }
}

