/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.personal;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.DimensionalNavbar;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.portalserver.PortalPage;
import com.arsdigita.portalserver.personal.PersonalPortalHomePage;
import com.arsdigita.portalserver.ui.PortalParticipants;
import com.arsdigita.portalserver.ui.admin.PortalAdminPage;
import com.arsdigita.portalserver.util.GlobalizationUtil;
import com.arsdigita.templating.PresentationManager;
import com.arsdigita.templating.Templating;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Application;
import com.arsdigita.web.BaseApplicationServlet;
import com.arsdigita.xml.Document;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class PersonalPortalServlet
extends BaseApplicationServlet {
    private static final Logger s_log = Logger.getLogger(PersonalPortalServlet.class);
    private static final PresentationManager s_presManager = Templating.getPresentationManager();
    private static Page s_homePage = new PersonalPortalHomePage();
    private static Page s_particPage = PortalParticipants.createPage();
    private static Page s_adminPage = new PortalAdminPage(){

        @Override
        protected void buildContextBar() {
            DimensionalNavbar navbar = new DimensionalNavbar();
            navbar.setClassAttr("portalNavbar");
            navbar.add((Component)new Link((PrintListener)new PortalPage.PersonalPortalLinkPrinter()));
            navbar.add((Component)new Label(GlobalizationUtil.globalize("cw.workspace.personal.configure_workspace")));
            this.getHeader().add((Component)navbar);
        }
    };

    public void doService(HttpServletRequest sreq, HttpServletResponse sresp, Application app) throws ServletException, IOException {
        s_log.debug((Object)("PortalServlet.doService called for request '" + sreq.getRequestURI() + "'"));
        String pathInfo = sreq.getPathInfo();
        Assert.exists((Object)pathInfo, (String)"String pathInfo");
        if (pathInfo.length() > 1 && pathInfo.endsWith("/")) {
            pathInfo = pathInfo.substring(0, pathInfo.length() - 1);
        }
        Document doc = null;
        doc = pathInfo.endsWith("participants") ? s_particPage.buildDocument(sreq, sresp) : (pathInfo.endsWith("admin") ? s_adminPage.buildDocument(sreq, sresp) : s_homePage.buildDocument(sreq, sresp));
        s_presManager.servePage(doc, sreq, sresp);
    }
}

