/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.ui;

import com.arsdigita.bebop.PropertySheetModel;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.Party;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.Role;
import com.arsdigita.portalserver.RoleCollection;
import com.arsdigita.portalserver.util.GlobalizationUtil;

class ParticipantModel
implements PropertySheetModel {
    int m_counter = -1;
    Party m_p;
    PortalSite m_psite;
    boolean m_includeRoles;

    ParticipantModel(Party p, PortalSite psite, boolean includeRoles) {
        this.m_p = p;
        this.m_psite = psite;
        this.m_includeRoles = includeRoles;
    }

    public boolean nextRow() {
        if (this.m_includeRoles && this.m_counter == 2 || !this.m_includeRoles && this.m_counter == 1) {
            return false;
        }
        ++this.m_counter;
        return true;
    }

    public String getLabel() {
        return this.getGlobalizedLabel().getKey();
    }

    public GlobalizedMessage getGlobalizedLabel() {
        if (this.m_counter == 0) {
            return GlobalizationUtil.globalize("cw.workspace.ui.email");
        }
        if (this.m_counter == 1) {
            return GlobalizationUtil.globalize("cw.workspace.ui.name");
        }
        if (this.m_counter == 2) {
            return GlobalizationUtil.globalize("cw.workspace.ui.roles");
        }
        throw new IllegalStateException("invalid counter");
    }

    public String getValue() {
        if (this.m_counter == 0) {
            if (this.m_p.getPrimaryEmail() != null) {
                return this.m_p.getPrimaryEmail().getEmailAddress();
            }
            return "None";
        }
        if (this.m_counter == 1) {
            return this.m_p.getDisplayName();
        }
        if (this.m_counter == 2) {
            StringBuffer result = new StringBuffer();
            boolean foundFirst = false;
            RoleCollection rc = this.m_psite.getRoles();
            while (rc.next()) {
                Role r = rc.getRole();
                if (!r.hasDirectMemberOrSubgroup(this.m_p)) continue;
                if (foundFirst) {
                    result.append(", ");
                }
                result.append(r.getAssigneeTitle());
                foundFirst = true;
            }
            return result.toString();
        }
        throw new IllegalStateException("invalid counter");
    }
}

