/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.DynamicListWizard;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.list.AbstractListModelBuilder;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.kernel.ACSObjectCollection;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.ui.ParticipantDisplay;
import com.arsdigita.portalserver.ui.ParticipantEdit;
import com.arsdigita.portalserver.util.GlobalizationUtil;
import com.arsdigita.toolbox.ui.ACSObjectCollectionListModel;
import com.arsdigita.toolbox.ui.PrivilegedComponentSelector;
import org.apache.log4j.Category;

public class ParticipantSearchPane {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/ui/ParticipantSearchPane.java#5 $$Author: dennis $$DateTime: 2004/08/17 23:19:25 $";
    private static Category s_log = Category.getInstance((String)ParticipantSearchPane.class.getName());

    private ParticipantSearchPane() {
    }

    public static Component create(RequestLocal portalsite, StringParameter actionParam, ActionListener selectSearch) {
        return ParticipantSearchPane.buildSearchPane(portalsite, actionParam, selectSearch);
    }

    private static Component buildSearchPane(final RequestLocal portalsiteRL, StringParameter actionParam, ActionListener selectSearch) {
        final ACSObjectSelectionModel selectionModel = new ACSObjectSelectionModel("selectedparticipant");
        final StringParameter searchString = new StringParameter("searchString");
        final List participantList = new List();
        participantList.setSelectionModel((SingleSelectionModel)selectionModel);
        final Label emptyView = new Label("");
        participantList.setEmptyView((Component)emptyView);
        participantList.setModelBuilder((ListModelBuilder)new AbstractListModelBuilder(){

            public ListModel makeModel(List l, PageState ps) {
                String searchStringValue = (String)ps.getValue((ParameterModel)searchString);
                if (searchStringValue == null || searchStringValue.equals("")) {
                    return new ListModel(){

                        public boolean next() {
                            return false;
                        }

                        public Object getElement() {
                            return null;
                        }

                        public String getKey() {
                            return null;
                        }
                    };
                }
                PortalSite psite = (PortalSite)((Object)portalsiteRL.get(ps));
                PartyCollection pc = psite.getParticipants();
                pc.filter(searchStringValue);
                long count = pc.size();
                if (count < 100L && count > 0L) {
                    return new ACSObjectCollectionListModel((ACSObjectCollection)pc);
                }
                if (count == 0L) {
                    emptyView.setLabel((String)GlobalizationUtil.globalize("cw.workspace.ui.no_matches_found").localize(), ps);
                } else {
                    emptyView.setLabel(count + " matches found. Please enter more" + " specific search criteria.", ps);
                }
                return new ListModel(){

                    public boolean next() {
                        return false;
                    }

                    public Object getElement() {
                        return null;
                    }

                    public String getKey() {
                        return null;
                    }
                };
            }
        });
        final DynamicListWizard dlw = new DynamicListWizard("Participants", (Component)participantList, (SingleSelectionModel)selectionModel, "", (Component)new Label("")){

            public void register(Page p) {
                super.register(p);
                p.addComponentStateParam((Component)this, (ParameterModel)searchString);
                p.setVisibleDefault((Component)this.getListLabel(), false);
                p.setVisibleDefault((Component)this.getAddLink(), false);
            }
        };
        Form searchForm = new Form("participantSearch", (Container)new ColumnPanel(1));
        Label searchLabel = new Label(GlobalizationUtil.globalize("cw.workspace.ui.enter_search_criteria"));
        searchLabel.setFontWeight("b");
        searchForm.add((Component)searchLabel);
        final TextField searchStringEntry = new TextField("searchEntry");
        searchStringEntry.addValidationListener((ParameterListener)new NotEmptyValidationListener("No search criteria entered"));
        searchForm.add((Component)searchStringEntry);
        searchForm.add((Component)new Submit("Search"));
        searchForm.addInitListener(new FormInitListener(){

            public void init(FormSectionEvent ev) {
                PageState ps = ev.getPageState();
                String searchStringValue = (String)ps.getValue((ParameterModel)searchString);
                if (searchStringValue == null) {
                    return;
                }
                searchStringEntry.setValue(ps, (Object)searchStringValue);
            }
        });
        searchForm.addSubmissionListener(new FormSubmissionListener(){

            public void submitted(FormSectionEvent ev) {
                PageState ps = ev.getPageState();
                ps.reset((Component)participantList);
                ps.setValue((ParameterModel)searchString, null);
            }
        });
        searchForm.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent ev) {
                PageState ps = ev.getPageState();
                ps.setValue((ParameterModel)searchString, searchStringEntry.getValue(ps));
            }
        });
        dlw.setHeader((Component)searchForm);
        RequestLocal participantRL = new RequestLocal(){

            public Object initialValue(PageState ps) {
                return selectionModel.getSelectedObject(ps);
            }
        };
        ParticipantEdit participantEdit = new ParticipantEdit(portalsiteRL, participantRL, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                dlw.reset(e.getPageState());
            }
        });
        ParticipantDisplay participantDisplay = new ParticipantDisplay(portalsiteRL, participantRL);
        PrivilegedComponentSelector participantEditOrDisplay = new PrivilegedComponentSelector(PrivilegeDescriptor.ADMIN, portalsiteRL, (Component)participantEdit, (Component)participantDisplay);
        dlw.setEditPane((Component)participantEditOrDisplay);
        selectionModel.addChangeListener(new ChangeListener((Component)participantEditOrDisplay){
            final /* synthetic */ Component val$participantEditOrDisplay;
            {
                this.val$participantEditOrDisplay = component;
            }

            public void stateChanged(ChangeEvent ev) {
                ev.getPageState().reset(this.val$participantEditOrDisplay);
            }
        });
        return dlw;
    }
}

