/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.TabbedPane;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.portalserver.PortalPage;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.ui.ParticipantBrowsePane;
import com.arsdigita.portalserver.ui.ParticipantPortalPage;
import com.arsdigita.portalserver.ui.ParticipantSearchPane;
import org.apache.log4j.Category;

public class PortalParticipants {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/ui/PortalParticipants.java#5 $$Author: dennis $$DateTime: 2004/08/17 23:19:25 $";
    private static Category s_log = Category.getInstance((String)PortalParticipants.class.getName());

    private PortalParticipants() {
    }

    public static PortalPage createPage() {
        final RequestLocal portalsiteRL = new RequestLocal(){

            public Object initialValue(PageState ps) {
                return PortalSite.getCurrentPortalSite(ps.getRequest());
            }
        };
        ParticipantPortalPage p = new ParticipantPortalPage();
        final StringParameter actionParam = new StringParameter("action");
        p.addGlobalStateParam((ParameterModel)actionParam);
        p.setTitle(new Label(new PrintListener(){

            public void prepare(PrintEvent ev) {
                Label tgt = (Label)ev.getTarget();
                PortalSite psite = (PortalSite)((Object)portalsiteRL.get(ev.getPageState()));
                tgt.setLabel(psite.getTitle() + " Participants");
            }
        }));
        final TabbedPane mainDisplay = new TabbedPane();
        Component browsePane = ParticipantBrowsePane.createForUser(portalsiteRL, actionParam, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                mainDisplay.setSelectedIndex(ev.getPageState(), 0);
            }
        });
        mainDisplay.addTab("Browse", browsePane);
        Component searchPane = ParticipantSearchPane.create(portalsiteRL, actionParam, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                mainDisplay.setSelectedIndex(ev.getPageState(), 1);
            }
        });
        mainDisplay.addTab("Search", searchPane);
        p.add((Component)mainDisplay);
        p.addRequestListener(new RequestListener(){

            public void pageRequested(RequestEvent ev) {
                PageState ps = ev.getPageState();
                String actionName = (String)ps.getValue((ParameterModel)actionParam);
                if (actionName != null && actionName.equals("search")) {
                    mainDisplay.setSelectedIndex(ps, 1);
                    ps.setValue((ParameterModel)actionParam, null);
                }
            }
        });
        p.lock();
        return p;
    }
}

