/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.ui.admin;

import com.arsdigita.bebop.AbstractSingleSelectionModel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ComponentSelectionModel;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Image;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.ModalContainer;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SplitWizard;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.kernel.ui.ResourceConfigFormSection;
import com.arsdigita.portal.Portlet;
import com.arsdigita.portalserver.PortalPage;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.ui.admin.ApplicationCreateComponent;
import com.arsdigita.portalserver.ui.admin.ApplicationModifyComponent;
import com.arsdigita.portalserver.util.GlobalizationUtil;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationCollection;
import com.arsdigita.web.ApplicationType;
import com.arsdigita.web.ApplicationTypeCollection;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

public final class ApplicationsPane {
    public static final String versionId = "$Id: //portalserver/dev/src/com/arsdigita/portalserver/ui/admin/ApplicationsPane.java#7 $$Author: dennis $$DateTime: 2004/08/17 23:19:25 $";
    private static final Logger s_log = Logger.getLogger((String)ApplicationsPane.class.getName());

    private ApplicationsPane() {
    }

    public static Component create(RequestLocal portalsiteRL) {
        final BigDecimalParameter appTypeParam = new BigDecimalParameter("at");
        final SplitWizard sw = new SplitWizard((Component)new Label("Please select an application type from the list on the left.")){

            public void respond(PageState ps) throws ServletException {
                String name = ps.getControlEventName();
                String value = ps.getControlEventValue();
                if ("apptype".equals(name)) {
                    ps.setValue((ParameterModel)appTypeParam, (Object)new BigDecimal(value));
                } else {
                    super.respond(ps);
                }
            }

            public void register(Page p) {
                super.register(p);
                p.addComponentStateParam((Component)this, (ParameterModel)appTypeParam);
            }
        };
        GridPanel appTypePanel = new GridPanel(1);
        ApplicationTypeCollection atc = ApplicationType.retrieveAllApplicationTypes();
        atc.filterToFullPageViewable();
        atc.filterToWorkspaceApplication();
        atc.orderByTitle();
        HashMap<BigDecimal, Component> map = new HashMap<BigDecimal, Component>();
        while (atc.next()) {
            final BigDecimal id = atc.getID();
            appTypePanel.add((Component)new ControlLink(atc.getTitle()){

                public void setControlEvent(PageState ps) {
                    ps.setControlEvent((Component)sw, "apptype", id.toString());
                }
            });
            ApplicationType appType = atc.getApplicationType();
            appType.disconnect();
            Component c = ApplicationsPane.editView(portalsiteRL, appType, true);
            sw.add(c);
            map.put(atc.getID(), c);
        }
        SimpleContainer leftPanel = new SimpleContainer();
        Label header = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.tool_type"));
        header.setFontWeight("b");
        leftPanel.add((Component)header);
        leftPanel.add((Component)appTypePanel);
        sw.setSelector((Component)leftPanel);
        sw.setSelectionModel((ComponentSelectionModel)new MapComponentSelector(map, (ParameterModel)appTypeParam));
        return sw;
    }

    static Component editView(RequestLocal portalsiteRL, ApplicationType type, boolean fullPagePortal) {
        final BigDecimalParameter selectedParam = new BigDecimalParameter("sp");
        final ModalContainer container = new ModalContainer(){

            public void register(Page p) {
                super.register(p);
                p.addComponentStateParam((Component)this, (ParameterModel)selectedParam);
            }
        };
        ActionListener reset = new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PageState ps = ev.getPageState();
                ps.reset((Component)container);
                ((PortalPage)ps.getPage()).goUnmodal(ps);
                container.setVisible(ps, true);
            }
        };
        RequestLocal selectedPortletRL = new RequestLocal(){

            protected Object initialValue(PageState ps) {
                BigDecimal portletID = (BigDecimal)ps.getValue((ParameterModel)selectedParam);
                if (portletID == null) {
                    return null;
                }
                return Portlet.retrievePortlet((BigDecimal)portletID);
            }
        };
        ApplicationModifyComponent portletModifyComponent = new ApplicationModifyComponent(selectedPortletRL, true, reset, reset);
        RequestLocal selectedAppRL = new RequestLocal(){

            protected Object initialValue(PageState ps) {
                BigDecimal appID = (BigDecimal)ps.getValue((ParameterModel)selectedParam);
                if (appID == null) {
                    return null;
                }
                return Application.retrieveApplication((BigDecimal)appID);
            }
        };
        ResourceConfigFormSection appModify = type.getModifyFormSection(selectedAppRL);
        Component appModifyForm = new ApplicationModifyComponent.DefaultBuilder(selectedAppRL, reset, reset).build(appModify);
        ResourceConfigFormSection appCreate = type.getCreateFormSection(portalsiteRL);
        final Component appCreateForm = new ApplicationCreateComponent.DefaultBuilder(reset, reset).build(appCreate);
        ApplicationsDisplay appsDisplay = new ApplicationsDisplay(portalsiteRL, type, fullPagePortal, (Component)portletModifyComponent, selectedParam, appModifyForm){
            final /* synthetic */ Component val$portletModifyComponent;
            final /* synthetic */ BigDecimalParameter val$selectedParam;
            final /* synthetic */ Component val$appModifyForm;
            {
                this.val$portletModifyComponent = component2;
                this.val$selectedParam = bigDecimalParameter;
                this.val$appModifyForm = component3;
                super(x0, x1, x2);
            }

            public void respond(PageState ps) throws ServletException {
                String name = ps.getControlEventName();
                String value = ps.getControlEventValue();
                if ("c".equals(name)) {
                    ((PortalPage)ps.getPage()).goModal(ps, appCreateForm);
                } else if ("cp".equals(name)) {
                    ((PortalPage)ps.getPage()).goModal(ps, this.val$portletModifyComponent);
                    ps.setValue((ParameterModel)this.val$selectedParam, (Object)new BigDecimal(value));
                } else if ("ca".equals(name)) {
                    ((PortalPage)ps.getPage()).goModal(ps, this.val$appModifyForm);
                    ps.setValue((ParameterModel)this.val$selectedParam, (Object)new BigDecimal(value));
                } else {
                    super.respond(ps);
                }
            }
        };
        container.add((Component)appsDisplay);
        container.add(appCreateForm);
        container.add((Component)portletModifyComponent);
        container.add(appModifyForm);
        container.setDefaultComponent((Component)appsDisplay);
        return container;
    }

    private static class ApplicationsDisplay
    extends SimpleComponent {
        static final String CREATE = "c";
        static final String CONFIG_PORTLET = "cp";
        static final String CONFIG_APP = "ca";
        private RequestLocal m_portalsiteRL;
        private ControlLink m_confLink;
        private Label m_linkLabel;
        private ControlLink m_link;
        private ApplicationType m_appType;
        private boolean m_fullPagePortal;

        ApplicationsDisplay(RequestLocal portalsiteRL, ApplicationType type, boolean fullPagePortal) {
            this.m_portalsiteRL = portalsiteRL;
            this.m_linkLabel = new Label("");
            this.m_link = new ControlLink((Component)this.m_linkLabel);
            Image i = new Image("/assets/general/Edit16.gif");
            i.setBorder("0");
            this.m_confLink = new ControlLink((Component)i);
            this.m_appType = type;
            this.m_fullPagePortal = fullPagePortal;
        }

        public void generateXML(PageState ps, Element parent) {
            PortalSite psite = (PortalSite)((Object)this.m_portalsiteRL.get(ps));
            parent = parent.newChildElement("portalserver:appsDisplay", "http://www.redhat.com/portalserver/1.0");
            parent.addAttribute("name", this.m_appType.getTitle());
            ApplicationCollection apps = this.m_fullPagePortal ? psite.getFullPagePortalSiteApplications() : psite.getChildApplications();
            apps.filterToApplicationType(this.m_appType.getApplicationObjectType());
            apps.orderByTitle();
            String currentObjectType = "";
            if (!this.m_appType.isSingleton() || apps.size() == 0L) {
                this.m_linkLabel.setLabel((String)GlobalizationUtil.globalize("cw.workspace.ui.admin.create_new").localize() + " " + this.m_appType.getTitle(), ps);
                ps.setControlEvent((Component)this, CREATE, "");
                this.m_link.setClassAttr("actionLink");
                this.m_link.generateXML(ps, parent);
            }
            while (apps.next()) {
                Element appElt = parent.newChildElement("portalserver:appsDisplayApp", "http://www.redhat.com/portalserver/1.0");
                this.m_linkLabel.setLabel(apps.getTitle(), ps);
                new Link((Component)this.m_linkLabel, apps.getPrimaryURL()).generateXML(ps, appElt);
                Element descr = appElt.newChildElement("portalserver:appsDisplayAppDescription", "http://www.redhat.com/portalserver/1.0");
                descr.setText(apps.getDescription());
                ps.setControlEvent((Component)this, CONFIG_APP, apps.getID().toString());
                this.m_confLink.generateXML(ps, appElt);
                ApplicationCollection portlets = apps.getApplication().getChildApplications();
                while (portlets.next()) {
                    Element port = appElt.newChildElement("portalserver:appsDisplayAppPortlet", "http://www.redhat.com/portalserver/1.0");
                    port.addAttribute("name", portlets.getTitle());
                    ps.setControlEvent((Component)this, CONFIG_PORTLET, portlets.getID().toString());
                    this.m_confLink.generateXML(ps, port);
                }
            }
        }
    }

    private static class MapComponentSelector
    extends AbstractSingleSelectionModel
    implements ComponentSelectionModel {
        private Map m_componentMap;
        private ParameterModel m_model;

        MapComponentSelector(Map componentMap, ParameterModel model) {
            this.m_componentMap = componentMap;
            this.m_model = model;
        }

        public Object getSelectedKey(PageState ps) {
            return ps.getValue(this.m_model);
        }

        public void setSelectedKey(PageState ps, Object key) {
            ps.setValue(this.m_model, key);
        }

        public Component getComponent(PageState ps) {
            return (Component)this.m_componentMap.get(this.getSelectedKey(ps));
        }

        public ParameterModel getStateParameter() {
            return this.m_model;
        }
    }
}

