/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.ui.admin;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.util.BebopConstants;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.PortalTab;
import com.arsdigita.portalserver.util.GlobalizationUtil;
import java.math.BigDecimal;

public class LockableLinks
extends SimpleContainer
implements BebopConstants {
    private static final String NARROW_UNLOCKED = "N";
    private static final String NARROW_LOCKED = "n";
    private static final String WIDE_UNLOCKED = "W";
    private static final String WIDE_LOCKED = "w";
    private final RequestLocal m_portalsiteRL;
    private final RequestLocal m_portalIDRL;
    ActionLink columnOneLink;
    ActionLink columnTwoLink;
    ActionLink columnThreeLink;

    public LockableLinks(RequestLocal portalsiteRL, RequestLocal portalIDRL) {
        this.m_portalsiteRL = portalsiteRL;
        this.m_portalIDRL = portalIDRL;
        Label columnOneLinkLabel = new Label("Lock/Unlock");
        columnOneLinkLabel.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState s = e.getPageState();
                Label t = (Label)e.getTarget();
                BigDecimal prtlID = (BigDecimal)LockableLinks.this.m_portalIDRL.get(s);
                PortalTab ptab = PortalTab.retrieveTab(prtlID);
                if (ptab != null) {
                    String layout = ptab.getLayout();
                    if (layout != null) {
                        String frag = layout.substring(0, 1);
                        if (frag.compareTo(LockableLinks.NARROW_LOCKED) == 0) {
                            t.setLabel(GlobalizationUtil.globalize("portalserver.ui.admin.unlock_column"));
                        } else if (frag.compareTo(LockableLinks.NARROW_UNLOCKED) == 0) {
                            t.setLabel(GlobalizationUtil.globalize("portalserver.ui.admin.lock_column"));
                        } else if (frag.compareTo(LockableLinks.WIDE_LOCKED) == 0) {
                            t.setLabel(GlobalizationUtil.globalize("portalserver.ui.admin.unlock_column"));
                        } else if (frag.compareTo(LockableLinks.WIDE_UNLOCKED) == 0) {
                            t.setLabel(GlobalizationUtil.globalize("portalserver.ui.admin.lock_column"));
                        }
                    }
                } else {
                    return;
                }
            }
        });
        this.columnOneLink = new ActionLink((Component)columnOneLinkLabel);
        this.columnOneLink.setIdAttr("columnonelocklink");
        this.columnOneLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String layout;
                PageState s = e.getPageState();
                BigDecimal prtlID = (BigDecimal)LockableLinks.this.m_portalIDRL.get(s);
                PortalTab ptab = PortalTab.retrieveTab(prtlID);
                if (ptab != null && (layout = ptab.getLayout()) != null) {
                    char c = layout.charAt(0);
                    String frag = layout.length() > 1 ? layout.substring(1) : "";
                    if (c == 'n') {
                        ptab.setLayout(LockableLinks.NARROW_UNLOCKED + frag);
                    } else if (c == 'N') {
                        ptab.setLayout(LockableLinks.NARROW_LOCKED + frag);
                    } else if (c == 'w') {
                        ptab.setLayout(LockableLinks.WIDE_UNLOCKED + frag);
                    } else if (c == 'W') {
                        ptab.setLayout(LockableLinks.WIDE_LOCKED + frag);
                    }
                    ptab.save();
                }
            }
        });
        Label columnTwoLinkLabel = new Label("Lock/Unlock");
        columnTwoLinkLabel.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState s = e.getPageState();
                Label t = (Label)e.getTarget();
                BigDecimal prtlID = (BigDecimal)LockableLinks.this.m_portalIDRL.get(s);
                PortalTab ptab = PortalTab.retrieveTab(prtlID);
                if (ptab != null) {
                    String layout = ptab.getLayout();
                    if (layout != null) {
                        if (layout.length() < 2) {
                            return;
                        }
                        String frag = layout.substring(1, 2);
                        if (frag.compareTo(LockableLinks.NARROW_LOCKED) == 0) {
                            t.setLabel(GlobalizationUtil.globalize("portalserver.ui.admin.unlock_column"));
                        } else if (frag.compareTo(LockableLinks.NARROW_UNLOCKED) == 0) {
                            t.setLabel(GlobalizationUtil.globalize("portalserver.ui.admin.lock_column"));
                        } else if (frag.compareTo(LockableLinks.WIDE_LOCKED) == 0) {
                            t.setLabel(GlobalizationUtil.globalize("portalserver.ui.admin.unlock_column"));
                        } else if (frag.compareTo(LockableLinks.WIDE_UNLOCKED) == 0) {
                            t.setLabel(GlobalizationUtil.globalize("portalserver.ui.admin.lock_column"));
                        }
                    }
                } else {
                    return;
                }
            }
        });
        this.columnTwoLink = new ActionLink((Component)columnTwoLinkLabel){

            public boolean isVisible(PageState s) {
                String layout;
                BigDecimal prtlID = (BigDecimal)LockableLinks.this.m_portalIDRL.get(s);
                PortalTab ptab = PortalTab.retrieveTab(prtlID);
                if (ptab != null && (layout = ptab.getLayout()) != null) {
                    return layout.length() >= 2;
                }
                return false;
            }
        };
        this.columnTwoLink.setIdAttr("columntwolocklink");
        this.columnTwoLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String layout;
                PageState s = e.getPageState();
                BigDecimal prtlID = (BigDecimal)LockableLinks.this.m_portalIDRL.get(s);
                PortalTab ptab = PortalTab.retrieveTab(prtlID);
                if (ptab != null && (layout = ptab.getLayout()) != null && layout.length() > 1) {
                    char c = layout.charAt(1);
                    String fragbegin = layout.substring(0, 1);
                    String fragend = layout.length() == 3 ? layout.substring(2, 3) : "";
                    if (c == 'n') {
                        ptab.setLayout(fragbegin + LockableLinks.NARROW_UNLOCKED + fragend);
                    } else if (c == 'N') {
                        ptab.setLayout(fragbegin + LockableLinks.NARROW_LOCKED + fragend);
                    } else if (c == 'w') {
                        ptab.setLayout(fragbegin + LockableLinks.WIDE_UNLOCKED + fragend);
                    } else if (c == 'W') {
                        ptab.setLayout(fragbegin + LockableLinks.WIDE_LOCKED + fragend);
                    }
                    ptab.save();
                }
            }
        });
        Label columnThreeLinkLabel = new Label("Lock/Unlock");
        columnThreeLinkLabel.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState s = e.getPageState();
                Label t = (Label)e.getTarget();
                BigDecimal prtlID = (BigDecimal)LockableLinks.this.m_portalIDRL.get(s);
                PortalTab ptab = PortalTab.retrieveTab(prtlID);
                if (ptab != null) {
                    String layout = ptab.getLayout();
                    if (layout != null) {
                        if (layout.length() < 3) {
                            return;
                        }
                        String frag = layout.substring(2, 3);
                        if (frag.compareTo(LockableLinks.NARROW_LOCKED) == 0) {
                            t.setLabel(GlobalizationUtil.globalize("portalserver.ui.admin.unlock_column"));
                        } else if (frag.compareTo(LockableLinks.NARROW_UNLOCKED) == 0) {
                            t.setLabel(GlobalizationUtil.globalize("portalserver.ui.admin.lock_column"));
                        } else if (frag.compareTo(LockableLinks.WIDE_LOCKED) == 0) {
                            t.setLabel(GlobalizationUtil.globalize("portalserver.ui.admin.unlock_column"));
                        } else if (frag.compareTo(LockableLinks.WIDE_UNLOCKED) == 0) {
                            t.setLabel(GlobalizationUtil.globalize("portalserver.ui.admin.lock_column"));
                        }
                    }
                } else {
                    return;
                }
            }
        });
        this.columnThreeLink = new ActionLink((Component)columnThreeLinkLabel){

            public boolean isVisible(PageState s) {
                String layout;
                BigDecimal prtlID = (BigDecimal)LockableLinks.this.m_portalIDRL.get(s);
                PortalTab ptab = PortalTab.retrieveTab(prtlID);
                if (ptab != null && (layout = ptab.getLayout()) != null) {
                    return layout.length() >= 3;
                }
                return false;
            }
        };
        this.columnThreeLink.setIdAttr("columnthreelocklink");
        this.columnThreeLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String layout;
                PageState s = e.getPageState();
                BigDecimal prtlID = (BigDecimal)LockableLinks.this.m_portalIDRL.get(s);
                PortalTab ptab = PortalTab.retrieveTab(prtlID);
                if (ptab != null && (layout = ptab.getLayout()) != null && layout.length() > 2) {
                    char c = layout.charAt(2);
                    String fragbegin = layout.substring(0, 2);
                    if (c == 'n') {
                        ptab.setLayout(fragbegin + LockableLinks.NARROW_UNLOCKED);
                    } else if (c == 'N') {
                        ptab.setLayout(fragbegin + LockableLinks.NARROW_LOCKED);
                    } else if (c == 'w') {
                        ptab.setLayout(fragbegin + LockableLinks.WIDE_UNLOCKED);
                    } else if (c == 'W') {
                        ptab.setLayout(fragbegin + LockableLinks.WIDE_LOCKED);
                    }
                    ptab.save();
                }
            }
        });
        this.add((Component)this.columnOneLink);
        this.add((Component)this.columnTwoLink);
        this.add((Component)this.columnThreeLink);
    }

    public boolean isVisible(PageState s) {
        PortalSite ps = (PortalSite)((Object)this.m_portalsiteRL.get(s));
        return ps.isPersonalizable();
    }
}

