/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.ui.admin;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SplitPanel;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.kernel.User;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.PortalSiteCollection;
import com.arsdigita.portalserver.personal.PersonalPortal;
import com.arsdigita.portalserver.util.GlobalizationUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class PortalArchivePanel
extends SplitPanel {
    List archiveList;
    List onlineList;
    Label m_noPortalSelected;
    ArchiveForm archiveForm;
    UnarchiveForm unarchiveForm;

    public PortalArchivePanel(Page p) {
        p.addRequestListener(new RequestListener(){

            public void pageRequested(RequestEvent e) {
                PageState ps = e.getPageState();
                if (!PortalArchivePanel.this.onlineList.isSelected(ps) && !PortalArchivePanel.this.archiveList.isSelected(ps)) {
                    PortalArchivePanel.this.archiveForm.setVisible(ps, false);
                    PortalArchivePanel.this.unarchiveForm.setVisible(ps, false);
                    PortalArchivePanel.this.m_noPortalSelected.setVisible(ps, true);
                }
            }
        });
        this.setClassAttr("archiver");
        this.setDivider(40);
        GridPanel headerPanel = new GridPanel(1);
        headerPanel.setClassAttr("archive_header");
        headerPanel.add((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.portal_archive_header")));
        this.setHeader((Component)headerPanel);
        GridPanel portalPanel = new GridPanel(1);
        portalPanel.setClassAttr("archive_panel");
        this.setLeftComponent((Component)portalPanel);
        GridPanel formPanel = new GridPanel(1);
        this.setRightComponent((Component)formPanel);
        this.archiveList = new List(new ListModelBuilder(){

            public ListModel makeModel(List l, PageState ps) {
                return new ArchiveListModel();
            }

            public void lock() {
            }

            public boolean isLocked() {
                return true;
            }
        });
        this.archiveList.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PageState ps = e.getPageState();
                PortalArchivePanel.this.archiveForm.setVisible(ps, false);
                PortalArchivePanel.this.unarchiveForm.setVisible(ps, true);
                PortalArchivePanel.this.m_noPortalSelected.setVisible(ps, false);
                PortalArchivePanel.this.onlineList.clearSelection(ps);
            }
        });
        this.archiveList.setCellRenderer((ListCellRenderer)new ArchiveListCellRenderer());
        this.archiveList.setClassAttr("archivelist");
        Label emptyarchive = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.empty_archive"));
        emptyarchive.setFontWeight("i");
        this.archiveList.setEmptyView((Component)emptyarchive);
        this.onlineList = new List(new ListModelBuilder(){

            public ListModel makeModel(List l, PageState ps) {
                return new OnlineListModel();
            }

            public void lock() {
            }

            public boolean isLocked() {
                return true;
            }
        });
        this.onlineList.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                PageState ps = e.getPageState();
                PortalArchivePanel.this.archiveForm.setVisible(ps, true);
                PortalArchivePanel.this.unarchiveForm.setVisible(ps, false);
                PortalArchivePanel.this.m_noPortalSelected.setVisible(ps, false);
                PortalArchivePanel.this.archiveList.clearSelection(ps);
            }
        });
        this.onlineList.setCellRenderer((ListCellRenderer)new OnlineListCellRenderer());
        this.onlineList.setClassAttr("onlinelist");
        Label emptyonline = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.empty_online"));
        emptyonline.setFontWeight("i");
        this.onlineList.setEmptyView((Component)emptyonline);
        Label onlinelabel = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.portals_currently_online"));
        onlinelabel.setFontWeight("b");
        portalPanel.add((Component)onlinelabel);
        portalPanel.add((Component)this.onlineList);
        Label archivelabel = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.portals_currently_archived"));
        archivelabel.setFontWeight("b");
        portalPanel.add((Component)archivelabel);
        portalPanel.add((Component)this.archiveList);
        this.archiveForm = new ArchiveForm();
        formPanel.add((Component)this.archiveForm);
        this.unarchiveForm = new UnarchiveForm();
        formPanel.add((Component)this.unarchiveForm);
        this.m_noPortalSelected = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.no_portal_selected"));
        this.m_noPortalSelected.setFontWeight("i");
        formPanel.add((Component)this.m_noPortalSelected);
    }

    class ArchiveListCellRenderer
    implements ListCellRenderer {
        ArchiveListCellRenderer() {
        }

        public Component getComponent(List list, PageState pageState, Object value, String key, int index, boolean isSelected) {
            String title;
            PortalSite ps = (PortalSite)((Object)value);
            if (ps instanceof PersonalPortal) {
                PersonalPortal pvt = (PersonalPortal)ps;
                User user = pvt.getOwningUser();
                title = user.getDisplayName() + " (personal)";
            } else {
                title = ps.getTitle();
            }
            SimpleDateFormat dft = new SimpleDateFormat();
            String d = dft.format(ps.getArchiveDate());
            if (isSelected) {
                Label label = new Label(title);
                label.setStyleAttr(d);
                return label;
            }
            ControlLink link = new ControlLink(title);
            link.setStyleAttr(d);
            return link;
        }
    }

    class OnlineListCellRenderer
    implements ListCellRenderer {
        OnlineListCellRenderer() {
        }

        public Component getComponent(List list, PageState pageState, Object value, String key, int index, boolean isSelected) {
            String title;
            PortalSite ps = (PortalSite)((Object)value);
            if (ps instanceof PersonalPortal) {
                PersonalPortal pvt = (PersonalPortal)ps;
                User user = pvt.getOwningUser();
                title = user.getDisplayName() + " (personal)";
            } else {
                title = ps.getTitle();
            }
            SimpleDateFormat dft = new SimpleDateFormat();
            Date cd = ps.getCreationDate();
            String date = cd == null ? "----" : dft.format(ps.getCreationDate());
            if (isSelected) {
                Label label = new Label(title);
                label.setStyleAttr(date);
                return label;
            }
            ControlLink link = new ControlLink(title);
            link.setStyleAttr(date);
            return link;
        }
    }

    public class UnarchiveForm
    extends Form
    implements FormProcessListener {
        private Label instruction;
        private Submit button;
        private Submit cancelbutton;

        public UnarchiveForm() {
            super("unarchiveform");
            this.instruction = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.online_this_portal"));
            this.button = new Submit(GlobalizationUtil.globalize("cw.workspace.ui.admin.unarchive"));
            this.cancelbutton = new Submit(GlobalizationUtil.globalize("cw.workspace.ui.admin.cancel"));
            this.add((Component)this.instruction);
            this.add((Component)this.button);
            this.add((Component)this.cancelbutton);
            this.addProcessListener(this);
        }

        public void process(FormSectionEvent e) {
            PageState s = e.getPageState();
            if (this.button.isSelected(s)) {
                String id = (String)PortalArchivePanel.this.archiveList.getSelectedKey(s);
                BigDecimal bd = new BigDecimal(id);
                PortalSite p = PortalSite.retrievePortalSite(bd);
                p.unarchive();
                p.save();
            }
            PortalArchivePanel.this.archiveList.clearSelection(s);
            this.setVisible(s, false);
            PortalArchivePanel.this.m_noPortalSelected.setVisible(s, true);
        }

        public void init(FormSectionEvent e) throws FormProcessException {
            PageState ps = e.getPageState();
            if (!PortalArchivePanel.this.onlineList.isSelected(ps) && !PortalArchivePanel.this.archiveList.isSelected(ps)) {
                this.setVisible(ps, false);
                PortalArchivePanel.this.m_noPortalSelected.setVisible(ps, true);
            }
        }
    }

    public class ArchiveForm
    extends Form
    implements FormProcessListener {
        private Label instruction;
        private Submit button;
        private Submit cancelbutton;
        private RadioGroup radio;
        private String recurse;

        public ArchiveForm() {
            super("archiveform");
            this.instruction = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.archive_this_portal"));
            this.button = new Submit(GlobalizationUtil.globalize("cw.workspace.ui.admin.archive"));
            this.cancelbutton = new Submit(GlobalizationUtil.globalize("cw.workspace.ui.admin.cancel"));
            this.radio = new RadioGroup("child_portals");
            this.radio.addOption(new Option("recurse", (Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.recurse_archive"))));
            this.add((Component)this.instruction);
            this.add((Component)this.button);
            this.add((Component)this.cancelbutton);
            this.add((Component)this.radio);
            this.addProcessListener(this);
        }

        public void process(FormSectionEvent e) {
            PageState s = e.getPageState();
            if (this.button.isSelected(s)) {
                this.recurse = (String)this.radio.getValue(s);
                String id = (String)PortalArchivePanel.this.onlineList.getSelectedKey(s);
                BigDecimal bd = new BigDecimal(id);
                PortalSite p = PortalSite.retrievePortalSite(bd);
                if (this.recurse == null) {
                    p.archive();
                } else {
                    p.archiveRecurse();
                }
                p.save();
            }
            PortalArchivePanel.this.onlineList.clearSelection(s);
            this.setVisible(s, false);
            PortalArchivePanel.this.m_noPortalSelected.setVisible(s, true);
        }

        public void init(FormSectionEvent e) throws FormProcessException {
            PageState ps = e.getPageState();
            if (!PortalArchivePanel.this.onlineList.isSelected(ps) && !PortalArchivePanel.this.archiveList.isSelected(ps)) {
                this.setVisible(ps, false);
                PortalArchivePanel.this.m_noPortalSelected.setVisible(ps, true);
            }
        }
    }

    static class OnlineListModel
    implements ListModel {
        PortalSiteCollection m_psites = PortalSite.retrieveAllPortalSites();
        PortalSite m_currSite;

        public OnlineListModel() {
            this.m_psites.filterForUnarchived();
        }

        public boolean next() {
            if (!this.m_psites.next()) {
                return false;
            }
            this.m_currSite = this.m_psites.getPortalSite();
            return true;
        }

        public Object getElement() {
            return this.m_currSite;
        }

        public String getKey() {
            return this.m_currSite.getID().toString();
        }
    }

    static class ArchiveListModel
    implements ListModel {
        PortalSiteCollection m_psites = PortalSite.retrieveAllPortalSites();
        PortalSite m_currSite;

        public ArchiveListModel() {
            this.m_psites.filterForArchived();
        }

        public boolean next() {
            if (!this.m_psites.next()) {
                return false;
            }
            this.m_currSite = this.m_psites.getPortalSite();
            return true;
        }

        public Object getElement() {
            return this.m_currSite;
        }

        public String getKey() {
            return this.m_currSite.getID().toString();
        }
    }
}

