/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.ui.admin;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.util.BebopConstants;
import com.arsdigita.portal.AgentPortlet;
import com.arsdigita.portal.Portal;
import com.arsdigita.portal.Portlet;
import com.arsdigita.portal.PortletCollection;
import com.arsdigita.portalserver.PortalTab;
import com.arsdigita.xml.Element;
import java.io.IOException;
import java.math.BigDecimal;

abstract class PortletLayoutComponent
extends SimpleComponent
implements BebopConstants {
    private static final String PREV_EVENT = "prev";
    private static final String NEXT_EVENT = "next";
    private static final String LEFT_EVENT = "left";
    private static final String RIGHT_EVENT = "right";
    private static final String DEL_EVENT = "del";
    private static final String CONFIG_EVENT = "cfg";
    private static final String PORTAL_XML_NS = "http://www.arsdigita.com/portalserver/1.0";
    private final RequestLocal m_portalsiteRL;
    private final RequestLocal m_portalIDRL;

    public PortletLayoutComponent(RequestLocal portalsiteRL, RequestLocal portalIDRL) {
        this.m_portalsiteRL = portalsiteRL;
        this.m_portalIDRL = portalIDRL;
    }

    private void generateXMLHelper(PageState ps, Portlet portlet, Element portalElt, boolean hasPrev, boolean hasNext, int numCols, String layout) {
        boolean isLocked = false;
        boolean canMoveLeft = true;
        boolean canMoveRight = true;
        Element portletElt = portalElt.newChildElement("bebop:portlet", "http://www.arsdigita.com/bebop/1.0");
        portletElt.addAttribute("title", portlet.getTitle());
        portletElt.addAttribute("cellNumber", Integer.toString(portlet.getCellNumber()));
        portletElt.addAttribute("sortKey", Integer.toString(portlet.getSortKey()));
        portletElt.addAttribute("profile", portlet.getProfile());
        portletElt.addAttribute("configure", "true");
        String portletIDstr = portlet.getID().toString();
        try {
            int cellNum = portlet.getCellNumber();
            if (layout.charAt(cellNum - 1) == 'n' || layout.charAt(cellNum - 1) == 'w') {
                isLocked = true;
            }
            if (layout.length() == 2) {
                if (cellNum == 1 && (layout.charAt(1) == 'n' || layout.charAt(1) == 'w')) {
                    canMoveRight = false;
                }
                if (cellNum == 2 && (layout.charAt(0) == 'n' || layout.charAt(0) == 'w')) {
                    canMoveLeft = false;
                }
            }
            if (layout.length() == 3) {
                if (cellNum == 1 && (layout.charAt(1) == 'n' || layout.charAt(1) == 'w')) {
                    canMoveRight = false;
                }
                if (cellNum == 3 && (layout.charAt(1) == 'n' || layout.charAt(1) == 'w')) {
                    canMoveLeft = false;
                }
                if (cellNum == 2) {
                    if (layout.charAt(0) == 'n' || layout.charAt(0) == 'w') {
                        canMoveLeft = false;
                    }
                    if (layout.charAt(2) == 'n' || layout.charAt(2) == 'w') {
                        canMoveRight = false;
                    }
                }
            }
            if (!isLocked) {
                ps.setControlEvent((Component)this, DEL_EVENT, portletIDstr);
                portletElt.addAttribute("delURL", ps.stateAsURL());
            }
            if (!(portlet instanceof AgentPortlet)) {
                ps.setControlEvent((Component)this, CONFIG_EVENT, portletIDstr);
                portletElt.addAttribute("cfgURL", ps.stateAsURL());
            }
            if (!isLocked && hasPrev) {
                ps.setControlEvent((Component)this, PREV_EVENT, portletIDstr);
                portletElt.addAttribute("prevURL", ps.stateAsURL());
            }
            if (!isLocked && hasNext) {
                ps.setControlEvent((Component)this, NEXT_EVENT, portletIDstr);
                portletElt.addAttribute("nextURL", ps.stateAsURL());
            }
            if (!isLocked && canMoveLeft && numCols != 1 && (numCols == 2 && cellNum == 2 || numCols == 3 && cellNum > 1)) {
                ps.setControlEvent((Component)this, LEFT_EVENT, portletIDstr);
                portletElt.addAttribute("leftURL", ps.stateAsURL());
            }
            if (!isLocked && canMoveRight && numCols != 1 && (numCols == 2 && cellNum != 2 || numCols == 3 && cellNum < numCols)) {
                ps.setControlEvent((Component)this, RIGHT_EVENT, portletIDstr);
                portletElt.addAttribute("rightURL", ps.stateAsURL());
            }
            ps.clearControlEvent();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Caught IOException: " + ex.getMessage());
        }
        Element labelElt = portletElt.newChildElement("bebop:label", "http://www.arsdigita.com/bebop/1.0");
        String desc = portlet.getPortletType().getDescription();
        if (desc == null) {
            desc = "";
        }
        labelElt.setText(desc);
    }

    public void generateXML(PageState ps, Element parentElt) {
        BigDecimal portalID = (BigDecimal)this.m_portalIDRL.get(ps);
        if (portalID == null) {
            return;
        }
        if (!PortalTab.doesTabExist(portalID)) {
            return;
        }
        int numCols = 0;
        PortalTab ptab = PortalTab.retrieveTab(portalID);
        String layout = ptab.getLayout();
        numCols = layout == null ? 2 : layout.length();
        Element portalElt = parentElt.newChildElement("bebop:portal", "http://www.arsdigita.com/bebop/1.0");
        this.exportAttributes(portalElt);
        portalElt.addAttribute("title", ptab.getTitle());
        portalElt.addAttribute("configure", "true");
        String layoutstyle = ptab.getLayout();
        if (layoutstyle != null) {
            layoutstyle = layoutstyle.toUpperCase();
        }
        portalElt.addAttribute("style", layoutstyle);
        PortletCollection portletCollection = ptab.getPortlets();
        if (!portletCollection.next()) {
            return;
        }
        boolean hasPrev = false;
        Portlet curr = portletCollection.getPortlet();
        Portlet next = null;
        while (portletCollection.next()) {
            next = portletCollection.getPortlet();
            if (curr.getCellNumber() != next.getCellNumber()) {
                this.generateXMLHelper(ps, curr, portalElt, hasPrev, false, numCols, layout);
                hasPrev = false;
            } else {
                this.generateXMLHelper(ps, curr, portalElt, hasPrev, true, numCols, layout);
                hasPrev = true;
            }
            curr = next;
        }
        this.generateXMLHelper(ps, curr, portalElt, hasPrev, false, numCols, layout);
    }

    public void respond(PageState ps) {
        String event = ps.getControlEventName();
        if (CONFIG_EVENT.equals(event)) {
            BigDecimal portletID = new BigDecimal(ps.getControlEventValue());
            this.handleConfigure(ps, portletID);
            return;
        }
        BigDecimal portletID = new BigDecimal(ps.getControlEventValue());
        Portlet portlet = Portlet.retrievePortlet((BigDecimal)portletID);
        Portal portal = portlet.getPortal();
        if (NEXT_EVENT.equals(event)) {
            portal.swapPortletWithNext(portlet);
        } else if (PREV_EVENT.equals(event)) {
            portal.swapPortletWithPrevious(portlet);
        } else if (LEFT_EVENT.equals(event)) {
            int cell = portlet.getCellNumber();
            if (--cell < 1) {
                cell = 1;
            }
            portlet.setCellNumber(cell);
            portlet.save();
        } else if (RIGHT_EVENT.equals(event)) {
            int cello = portlet.getCellNumber();
            if (++cello > 3) {
                cello = 3;
            }
            portlet.setCellNumber(cello);
            portlet.save();
        } else if (DEL_EVENT.equals(event)) {
            portlet.delete();
        } else {
            throw new IllegalStateException("Unknown portlet layout event");
        }
        portal.save();
    }

    protected abstract void handleConfigure(PageState var1, BigDecimal var2);
}

