/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.ui.admin;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.DynamicListWizard;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.ACSObjectCollection;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.Role;
import com.arsdigita.portalserver.RoleCollection;
import com.arsdigita.portalserver.permissions.PartyPermissionEdit;
import com.arsdigita.portalserver.util.GlobalizationUtil;
import com.arsdigita.toolbox.ui.ACSObjectCollectionListModel;

public class RolePane {
    public static Component create(final RequestLocal portalsiteRL) {
        final ACSObjectSelectionModel selectionModel = new ACSObjectSelectionModel("selectedRole");
        List rList = new List(new ListModelBuilder(){

            public ListModel makeModel(List l, PageState ps) {
                PortalSite p = (PortalSite)((Object)portalsiteRL.get(ps));
                return new ACSObjectCollectionListModel((ACSObjectCollection)p.getRoles()){

                    public Object getElement() {
                        RoleCollection rc = (RoleCollection)this.getCollection();
                        if (rc.isSystem()) {
                            return rc.getRoleName() + "*";
                        }
                        return rc.getRoleName();
                    }
                };
            }

            public void lock() {
            }

            public boolean isLocked() {
                return true;
            }
        });
        rList.setSelectionModel((SingleSelectionModel)selectionModel);
        Label emptyView = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.no_roles_defined"));
        emptyView.setFontWeight("i");
        rList.setEmptyView((Component)emptyView);
        DynamicListWizard dlw = new DynamicListWizard("Roles", (Component)rList, (SingleSelectionModel)selectionModel, "Add a role", (Component)new Label(""));
        final RequestLocal roleRL = new RequestLocal(){

            public Object initialValue(PageState ps) {
                return (Role)selectionModel.getSelectedObject(ps);
            }
        };
        dlw.setAddPane(RolePane.addPane(roleRL, portalsiteRL, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PageState ps = ev.getPageState();
                selectionModel.setSelectedObject(ps, (DomainObject)((Role)((Object)roleRL.get(ps))));
            }
        }));
        dlw.setEditPane(RolePane.editPane(roleRL, portalsiteRL, new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                PageState ps = ev.getPageState();
                selectionModel.setSelectedObject(ps, null);
            }
        }));
        return dlw;
    }

    private static Component addPane(final RequestLocal roleRL, final RequestLocal portalsiteRL, final ActionListener onAdd) {
        final Form result = new Form("roleAdd");
        result.add((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.role_name")));
        final TextField roleNameField = new TextField("roleName");
        roleNameField.getParameterModel().addParameterListener((ParameterListener)new NotEmptyValidationListener());
        result.add((Component)roleNameField);
        result.add((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.assignee_title")));
        final TextField assigneeTitleField = new TextField("assigneeTitle");
        assigneeTitleField.getParameterModel().addParameterListener((ParameterListener)new NotEmptyValidationListener());
        result.add((Component)assigneeTitleField);
        result.add((Component)new Label());
        result.add((Component)new Submit("Add Role"));
        result.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent ev) {
                PageState ps = ev.getPageState();
                String roleName = (String)roleNameField.getValue(ps);
                String assigneeTitle = (String)assigneeTitleField.getValue(ps);
                PortalSite psite = (PortalSite)((Object)portalsiteRL.get(ps));
                Role newRole = Role.createRole((PortalSite)((Object)portalsiteRL.get(ps)), roleName, assigneeTitle, "");
                newRole.save();
                PermissionService.grantPermission((PermissionDescriptor)new PermissionDescriptor(PrivilegeDescriptor.READ, (ACSObject)psite, (Party)newRole));
                roleRL.set(ps, (Object)newRole);
                onAdd.actionPerformed(new ActionEvent((Component)result, ps));
            }
        });
        return result;
    }

    private static Component editPane(final RequestLocal roleRL, RequestLocal portalsiteRL, final ActionListener onDelete) {
        final BoxPanel result = new BoxPanel();
        result.setWidth("100%");
        GridPanel formPanel = new GridPanel(2);
        Form properties = new Form("roleEdit", (Container)formPanel);
        properties.add((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.role_name")));
        final TextField roleNameEntry = new TextField("roleName"){

            public boolean isVisible(PageState ps) {
                Role r = (Role)((Object)roleRL.get(ps));
                return r != null && !r.isSystem();
            }
        };
        roleNameEntry.addValidationListener((ParameterListener)new NotEmptyValidationListener());
        final Label roleNameDisplay = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.null_role")){

            public boolean isVisible(PageState ps) {
                Role r = (Role)((Object)roleRL.get(ps));
                return !roleNameEntry.isVisible(ps);
            }
        };
        roleNameDisplay.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent ev) {
                Role r = (Role)((Object)roleRL.get(ev.getPageState()));
                if (r == null) {
                    return;
                }
                Label tgt = (Label)ev.getTarget();
                tgt.setLabel(r.getRoleName());
            }
        });
        SimpleContainer roleNameComposite = new SimpleContainer();
        roleNameComposite.add((Component)roleNameEntry);
        roleNameComposite.add((Component)roleNameDisplay);
        properties.add((Component)roleNameComposite);
        properties.add((Component)new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.assignee_title")));
        final TextField titleEntry = new TextField("assigneeTitle"){

            public boolean isVisible(PageState ps) {
                return roleNameEntry.isVisible(ps);
            }
        };
        titleEntry.addValidationListener((ParameterListener)new NotEmptyValidationListener());
        Label titleDisplay = new Label(GlobalizationUtil.globalize("cw.workspace.ui.admin.null_assignee_title")){

            public boolean isVisible(PageState ps) {
                return roleNameDisplay.isVisible(ps);
            }
        };
        titleDisplay.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent ev) {
                Role r = (Role)((Object)roleRL.get(ev.getPageState()));
                if (r == null) {
                    return;
                }
                Label tgt = (Label)ev.getTarget();
                tgt.setLabel(r.getAssigneeTitle());
            }
        });
        SimpleContainer titleComposite = new SimpleContainer();
        titleComposite.add((Component)titleEntry);
        titleComposite.add((Component)titleDisplay);
        properties.add((Component)titleComposite);
        properties.add((Component)new Label());
        properties.add((Component)new Submit("Update Role"){

            public boolean isVisible(PageState ps) {
                return roleNameEntry.isVisible(ps);
            }
        });
        properties.addInitListener(new FormInitListener(){

            public void init(FormSectionEvent ev) {
                PageState ps = ev.getPageState();
                Role role = (Role)((Object)roleRL.get(ps));
                roleNameEntry.setValue(ps, (Object)role.getRoleName());
            }
        });
        properties.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent ev) throws FormProcessException {
                PageState ps = ev.getPageState();
                Role role = (Role)((Object)roleRL.get(ps));
                if (!role.isSystem()) {
                    String newRoleName = (String)roleNameEntry.getValue(ps);
                    String newTitle = (String)titleEntry.getValue(ps);
                    role.setRoleName(newRoleName);
                    role.setAssigneeTitle(newTitle);
                    role.save();
                }
            }
        });
        result.add((Component)properties);
        ActionLink deleteRole = new ActionLink((String)GlobalizationUtil.globalize("cw.workspace.ui.admin.delete_role").localize()){

            public boolean isVisible(PageState ps) {
                Role r = (Role)((Object)roleRL.get(ps));
                return !r.isSystem();
            }
        };
        deleteRole.setConfirmation("Really delete portal role?");
        deleteRole.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState ps = e.getPageState();
                Role r = (Role)((Object)roleRL.get(ps));
                r.delete();
                onDelete.actionPerformed(new ActionEvent((Component)result, ps));
            }
        });
        result.add((Component)deleteRole);
        PartyPermissionEdit permWidget = new PartyPermissionEdit("Privileges", portalsiteRL, roleRL);
        result.add((Component)permWidget);
        return result;
    }
}

