/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.portalserver.ui.admin;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.portalserver.ColorPicker;
import com.arsdigita.portalserver.PortalSite;
import com.arsdigita.portalserver.Theme;
import com.arsdigita.portalserver.ThemeCollection;
import com.arsdigita.portalserver.util.GlobalizationUtil;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class ThemesPane
extends SimpleContainer {
    private static final Logger s_log = Logger.getLogger(ThemesPane.class);
    private RadioGroup m_grp = new RadioGroup("themes");
    private Submit createButton;
    private SelectThemeForm m_selectForm;
    private CreateThemeForm m_createForm;
    ActionLink m_createThemeLink;

    public ThemesPane(RequestLocal portalsiteRL) {
        this.m_grp.setClassAttr("vertical");
        this.populateOptionGroup();
        this.m_selectForm = new SelectThemeForm(portalsiteRL);
        this.m_createForm = new CreateThemeForm(portalsiteRL);
        this.add((Component)this.m_selectForm);
        this.add((Component)this.m_createForm);
    }

    void populateOptionGroup() {
        this.m_grp.clearOptions();
        ThemeCollection collection = Theme.retrieveAllThemes();
        while (collection.next()) {
            this.m_grp.addOption(new Option(collection.getTheme().getID().toString(), collection.getTheme().getName()));
        }
    }

    private class CreateThemeLinkListener
    implements ActionListener {
        private CreateThemeLinkListener() {
        }

        public void actionPerformed(ActionEvent event) {
            PageState ps = event.getPageState();
            ThemesPane.this.m_createForm.setVisible(ps, true);
            ThemesPane.this.m_selectForm.setVisible(ps, false);
            ThemesPane.this.m_createThemeLink.setVisible(ps, false);
        }
    }

    public class CreateThemeForm
    extends Form
    implements FormProcessListener,
    FormInitListener {
        private Label instruction;
        private Submit savebutton;
        private Submit cancelbutton;
        private TextField themename;
        private ColorPicker globalheader;
        private ColorPicker globalheadertext;
        private ColorPicker background;
        private ColorPicker text;
        private ColorPicker activetab;
        private ColorPicker inactivetab;
        private ColorPicker activetabtext;
        private ColorPicker inactivetabtext;
        private ColorPicker toprule;
        private ColorPicker bottomrule;
        private ColorPicker portletheader;
        private ColorPicker portletborder;
        private ColorPicker portletheadertext;
        private ColorPicker portletbodynarrow;
        RequestLocal prtlRL;

        public CreateThemeForm(RequestLocal portalsiteRL) {
            super("createthemeform");
            this.prtlRL = portalsiteRL;
            this.setClassAttr("themecreator");
            this.savebutton = new Submit("savetheme");
            this.savebutton.setButtonLabel("Save Theme");
            this.instruction = new Label(GlobalizationUtil.globalize("portalserver.ui.admin.create_theme_instruction"));
            this.globalheader = new ColorPicker("Page Header Color ", "#112233");
            this.globalheadertext = new ColorPicker("Page Header Text Color ", "#112233");
            this.background = new ColorPicker("Page Background Color ", "#112233");
            this.text = new ColorPicker("Page Text Color ", "#112233");
            this.activetab = new ColorPicker("Selected Tab Color ", "#1F22B3");
            this.inactivetab = new ColorPicker("Unselected Tab Color ", "#112233");
            this.activetabtext = new ColorPicker("Selected Tab Text Color", "#FFFFFF");
            this.inactivetabtext = new ColorPicker("Unselected Tab Text Color ", "#11CC33");
            this.toprule = new ColorPicker("Top Rule Color ", "#FFFFFF");
            this.bottomrule = new ColorPicker("Bottom Rule Color ", "#FFFFFF");
            this.portletheader = new ColorPicker("Portlet Header Color ", "#FFFFFF");
            this.portletborder = new ColorPicker("Portlet Border Color ", "#FFFFFF");
            this.portletheadertext = new ColorPicker("Portlet Header Text Color ", "#FFFFFF");
            this.portletbodynarrow = new ColorPicker("Narrow Column Portlet Body Color ", "#FFFFFF");
            this.themename = new TextField("themename");
            this.themename.addValidationListener((ParameterListener)new NotNullValidationListener("Please provide a name for this theme."));
            this.add((Component)this.instruction);
            this.add((Component)this.themename);
            this.add((Component)this.background);
            this.add((Component)this.text);
            this.add((Component)this.globalheader);
            this.add((Component)this.globalheadertext);
            this.add((Component)this.activetab);
            this.add((Component)this.inactivetab);
            this.add((Component)this.activetabtext);
            this.add((Component)this.inactivetabtext);
            this.add((Component)this.toprule);
            this.add((Component)this.bottomrule);
            this.add((Component)this.portletheader);
            this.add((Component)this.portletheadertext);
            this.add((Component)this.portletborder);
            this.add((Component)this.portletbodynarrow);
            this.add((Component)this.savebutton);
            this.addProcessListener(this);
            this.addInitListener(this);
        }

        public void process(FormSectionEvent e) {
            PageState ps = e.getPageState();
            if (this.savebutton.isSelected(ps)) {
                Theme theme = new Theme((String)this.themename.getValue(ps));
                theme.setActiveTabColor(this.activetab.getValue(ps));
                theme.setInactiveTabColor(this.inactivetab.getValue(ps));
                theme.setActiveTabTextColor(this.activetabtext.getValue(ps));
                theme.setInactiveTabTextColor(this.inactivetabtext.getValue(ps));
                theme.setTopRuleColor(this.toprule.getValue(ps));
                theme.setBottomRuleColor(this.bottomrule.getValue(ps));
                theme.setPortletHeaderColor(this.portletheader.getValue(ps));
                theme.setPortletIconColor(this.portletheader.getValue(ps));
                theme.setPortletBorderColor(this.portletborder.getValue(ps));
                theme.setPortletHeaderTextColor(this.portletheadertext.getValue(ps));
                theme.setPageBGColor(this.background.getValue(ps));
                theme.setBodyTextColor(this.text.getValue(ps));
                theme.setNarrowBGColor(this.portletbodynarrow.getValue(ps));
                theme.save();
            }
            ThemesPane.this.m_selectForm.setVisible(ps, true);
            ThemesPane.this.m_createThemeLink.setVisible(ps, true);
            this.setVisible(ps, false);
        }

        public void init(FormSectionEvent e) throws FormProcessException {
        }
    }

    public class SelectThemeForm
    extends Form
    implements FormProcessListener,
    FormInitListener {
        private Label instruction;
        private Submit button;
        RequestLocal prtlRL;

        public SelectThemeForm(RequestLocal portalsiteRL) {
            super("selectthemeform");
            this.prtlRL = portalsiteRL;
            this.instruction = new Label(GlobalizationUtil.globalize("portalserver.ui.admin.select_theme_for_portal"));
            this.button = new Submit("selecttheme", GlobalizationUtil.globalize("portalserver.ui.select_theme"));
            this.button.setButtonLabel("Select Theme");
            this.add((Component)this.instruction);
            this.add((Component)this.button);
            ThemesPane.this.m_grp.addValidationListener((ParameterListener)new NotNullValidationListener("Select a Theme"));
            this.add((Component)ThemesPane.this.m_grp);
            this.addProcessListener(this);
            this.addInitListener(this);
        }

        public void process(FormSectionEvent e) {
            PageState s = e.getPageState();
            if (this.button.isSelected(s)) {
                String selectedkey = (String)ThemesPane.this.m_grp.getValue(s);
                BigDecimal bd = new BigDecimal(selectedkey);
                Theme theme = Theme.retrieveTheme(bd);
                PortalSite p = (PortalSite)((Object)this.prtlRL.get(s));
                p.setTheme(theme);
                p.save();
            }
        }

        public void init(FormSectionEvent e) throws FormProcessException {
            PageState ps = e.getPageState();
            if (this.isVisible(ps)) {
                ThemesPane.this.m_createForm.setVisible(ps, false);
            }
            FormData fd = e.getFormData();
            PortalSite p = (PortalSite)((Object)this.prtlRL.get(ps));
            Theme theme = p.getTheme();
            if (theme != null) {
                fd.put((Object)"themes", (Object)theme.getID().toString());
            }
        }
    }
}

