/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import java.util.Iterator;
import java.util.LinkedList;

public class IsoCountry
extends DomainObject {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contenttypes.IsoCountry";
    public static final String ISO_CODE = "isoCode";
    public static final String COUNTRY_NAME = "countryName";

    public IsoCountry() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public IsoCountry(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public IsoCountry(DataObject obj) {
        super(obj);
    }

    public String getIsoCode() {
        return (String)this.get(ISO_CODE);
    }

    public void setIsoCode(String isoCode) {
        this.set(ISO_CODE, isoCode);
    }

    public String getCountryName() {
        return (String)this.get(COUNTRY_NAME);
    }

    public void setCountryName(String countryName) {
        this.set(COUNTRY_NAME, countryName);
    }

    public static DomainCollection retrieveAll() {
        DataCollection isoCodes = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        isoCodes.addOrder(COUNTRY_NAME);
        return new DomainCollection(isoCodes){};
    }

    public static Iterator getIsoCodes() {
        LinkedList<String> list = new LinkedList<String>();
        DataCollection isoCodes = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        while (isoCodes.next()) {
            IsoCountry country = new IsoCountry(isoCodes.getDataObject());
            list.addLast(country.getIsoCode());
        }
        if (list.size() != 0) {
            return list.iterator();
        }
        return null;
    }
}

