/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.SimpleAddress;
import com.arsdigita.cms.contenttypes.ui.SimpleAddressPropertyForm;
import com.arsdigita.cms.contenttypes.util.SimpleAddressGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.toolbox.ui.ComponentAccess;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;

public class SimpleAddressPropertiesStep
extends SimpleEditStep {
    public static final String EDIT_SHEET_NAME = "edit";

    public SimpleAddressPropertiesStep(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        super(itemModel, parent);
        this.setDefaultEditKey(EDIT_SHEET_NAME);
        SimpleAddressPropertyForm editSheet = new SimpleAddressPropertyForm(itemModel, this);
        this.add(EDIT_SHEET_NAME, GlobalizationUtil.globalize((String)"cms.ui.edit"), (ComponentAccess)new WorkflowLockedComponentAccess((Component)editSheet, itemModel), editSheet.getSaveCancelSection().getCancelButton());
        this.setDisplayComponent(SimpleAddressPropertiesStep.getAddressPropertySheet(itemModel));
    }

    public static Component getAddressPropertySheet(ItemSelectionModel itemModel) {
        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet((DomainObjectSelectionModel)itemModel);
        sheet.add(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.title"), "title");
        sheet.add(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.name"), "name");
        if (!ContentSection.getConfig().getHideLaunchDate()) {
            sheet.add(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.launch_date"), "launchDate", (DomainObjectPropertySheet.AttributeFormatter)new SimpleEditStep.LaunchDateAttributeFormatter());
        }
        sheet.add(SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.address"), "address");
        if (!SimpleAddress.getConfig().getHideCountryCodeSelection()) {
            sheet.add(SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.iso_country_code"), "isoCountryCode", new DomainObjectPropertySheet.AttributeFormatter(){

                public String format(DomainObject item, String attribute, PageState state) {
                    SimpleAddress address = (SimpleAddress)item;
                    if (address.getCountryIsoCode() != null) {
                        return address.getCountryIsoCode();
                    }
                    return (String)GlobalizationUtil.globalize((String)"cms.ui.unknown").localize();
                }
            });
        }
        if (!SimpleAddress.getConfig().getHidePostalCode()) {
            sheet.add(SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.postal_code"), "postalCode");
        }
        sheet.add(SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.phone"), "phone");
        sheet.add(SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.mobile"), "mobile");
        sheet.add(SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.fax"), "fax");
        sheet.add(SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.email"), "email");
        sheet.add(SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.uri"), "uri");
        sheet.add(SimpleAddressGlobalizationUtil.globalize("cms.contenttypes.ui.simpleaddress.notes"), "notes");
        return sheet;
    }
}

