/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.contenttypes.SiteProxy;
import com.arsdigita.cms.contenttypes.util.SiteProxyGlobalizationUtil;
import com.arsdigita.cms.dispatcher.ContentPanel;
import com.arsdigita.cms.dispatcher.SimpleXMLGenerator;
import com.arsdigita.cms.dispatcher.XMLGenerator;
import com.arsdigita.util.url.URLCache;
import com.arsdigita.util.url.URLData;
import com.arsdigita.util.url.URLFetcher;
import com.arsdigita.util.url.URLPool;
import com.arsdigita.xml.Document;
import com.arsdigita.xml.Element;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class SiteProxyPanel
extends ContentPanel {
    private static Logger s_log = Logger.getLogger(SiteProxyPanel.class);
    private static String SITE_PROXY_PANEL_NAME = "cms:siteProxyPanel";
    private static String DATA_TYPE = "dataType";
    private static String C_DATA_DATA_TYPE = "cdata";
    private static String XML_DATA_TYPE = "xml";
    private static String s_cacheServiceKey = "SiteProxyPanel";
    private static URLCache s_cache = new URLCache(1000000L, 900000L);
    private static URLPool s_pool = new URLPool();

    protected XMLGenerator getXMLGenerator(PageState state) {
        return new SiteProxyXMLGenerator();
    }

    public static URLData internalGetRemoteXML(Element child, String url) {
        URLData data = URLFetcher.fetchURLData((String)url, (String)s_cacheServiceKey);
        if (data == null || data.getException() != null || data.getContent().length == 0) {
            return data;
        }
        String contentType = data.getContentType();
        boolean success = false;
        if (contentType != null && contentType.toLowerCase().indexOf("/xml") > -1) {
            Document document = null;
            try {
                document = new Document(data.getContent());
                success = true;
            }
            catch (Exception ex) {
                s_log.info((Object)("The document is not proper XML, trying to add the property xml headers to the file retrieved from " + url), (Throwable)ex);
                try {
                    String xmlString = data.getContentAsString();
                    xmlString = "<?xml version=\"1.0\"?> \n" + xmlString;
                    document = new Document(xmlString);
                    success = true;
                    s_log.info((Object)("Adding the headers to " + url + " allowed it to be properly parsed."));
                }
                catch (Exception exception) {
                    s_log.info((Object)("The document found at " + url + " is not correctly formed XML"), (Throwable)exception);
                }
            }
            if (success) {
                child.addContent(document.getRootElement());
                child.addAttribute(DATA_TYPE, XML_DATA_TYPE);
            }
        }
        if (!success) {
            child.setCDATASection(data.getContentAsString());
            child.addAttribute(DATA_TYPE, C_DATA_DATA_TYPE);
        }
        return data;
    }

    private String passParameters(HttpServletRequest request, String url) {
        StringBuffer sb = new StringBuffer(url);
        String enc = request.getCharacterEncoding();
        if (enc == null) {
            enc = "UTF-8";
        }
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            String paramName = (String)en.nextElement();
            String[] paramValues = request.getParameterValues(paramName);
            for (int i = 0; i < paramValues.length; ++i) {
                if (sb.indexOf("?") < 0) {
                    sb.append("?");
                } else {
                    sb.append("&");
                }
                sb.append(paramName).append("=");
                try {
                    sb.append(URLEncoder.encode(paramValues[i], enc));
                    continue;
                }
                catch (UnsupportedEncodingException ex) {
                    s_log.error((Object)"Unable to encode SiteProxy request", (Throwable)ex);
                    return url;
                }
            }
        }
        return sb.toString();
    }

    static {
        s_log.debug((Object)"Static initalizer starting...");
        URLFetcher.registerService((String)s_cacheServiceKey, (URLPool)s_pool, (URLCache)s_cache);
        s_log.debug((Object)"Static initalizer finished.");
    }

    class SiteProxyXMLGenerator
    extends SimpleXMLGenerator {
        SiteProxyXMLGenerator() {
        }

        public void generateXML(PageState state, Element parent, String useContext) {
            ContentSection section = CMS.getContext().getContentSection();
            SiteProxy item = (SiteProxy)this.getContentItem(state);
            String url = SiteProxyPanel.this.passParameters(state.getRequest(), item.getURL());
            Element child = parent.newChildElement(SITE_PROXY_PANEL_NAME, "http://www.arsdigita.com/cms/1.0");
            URLData data = SiteProxyPanel.internalGetRemoteXML(child, url);
            if (data == null) {
                Object[] urlArray = new String[]{url};
                new Label(SiteProxyGlobalizationUtil.globalize("cms.contenttypes.dispatcher.siteproxy.error_fetching_url", urlArray)).generateXML(state, parent);
            } else if (data.getException() != null) {
                Object[] urlArray = new String[]{url, data.getException().getClass().getName(), data.getException().getMessage()};
                new Label(SiteProxyGlobalizationUtil.globalize("cms.contenttypes.siteproxy.dispatcher.exception_fetching_url", urlArray)).generateXML(state, parent);
            } else if (data.getContent().length == 0) {
                Object[] urlArray = new String[]{url};
                new Label(SiteProxyGlobalizationUtil.globalize("cms.contenttypes.siteproxy.dispatcher.empty_page_returned", urlArray)).generateXML(state, parent);
            }
        }
    }
}

