/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.faq.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.faq.ApplicationAuthenticationListener;
import com.arsdigita.faq.Faq;
import com.arsdigita.faq.ui.FaqBasePage;
import com.arsdigita.util.Assert;
import com.arsdigita.util.StringUtils;
import com.arsdigita.web.Application;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class FaqPage
extends FaqBasePage {
    private static final Logger log = Logger.getLogger(FaqPage.class);
    public static final String FAQ_XML_NS = "http://www.arsdigita.com/faq/1.0";
    private SingleSelectionModel m_questionSelection;

    public FaqPage() {
        this("user");
    }

    public FaqPage(String view) {
        super(view);
        if (view.equals("admin")) {
            this.addRequestListener(new ApplicationAuthenticationListener("admin"));
        }
    }

    void setQuestionSelectionModel(SingleSelectionModel selection) {
        this.m_questionSelection = selection;
    }

    BigDecimal getQuestionID(PageState s) {
        String key = (String)this.m_questionSelection.getSelectedKey(s);
        if (StringUtils.emptyString((String)key)) {
            return null;
        }
        return new BigDecimal(key);
    }

    public BigDecimal getFaqID(PageState state) {
        Faq faq = this.getFaq(state);
        Assert.exists((Object)((Object)faq), (String)"faq");
        return faq.getID();
    }

    public Faq getFaq(PageState state) {
        return (Faq)Application.getCurrentApplication((HttpServletRequest)state.getRequest());
    }

    public static String generateHTMLText(String text, String formatType) {
        if (text == null) {
            return "";
        }
        if (formatType.equals("text/html")) {
            return text;
        }
        if (formatType.equals("text/plain; format=preformatted")) {
            return "<pre>" + text + "</pre>";
        }
        return StringUtils.textToHtml((String)text);
    }
}

