/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.auth.http;

import com.arsdigita.auth.http.Inet4AddressRange;
import com.arsdigita.runtime.AbstractConfig;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.parameter.AbstractParameter;
import com.arsdigita.util.parameter.BooleanParameter;
import com.arsdigita.util.parameter.Converters;
import com.arsdigita.util.parameter.IntegerParameter;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.StringParameter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import org.apache.commons.beanutils.Converter;
import org.apache.log4j.Logger;

public class HTTPAuthConfig
extends AbstractConfig {
    private static final Logger logger = Logger.getLogger(HTTPAuthConfig.class);
    private BooleanParameter m_isActive = new BooleanParameter("com.arsdigita.auth.http.active", 0, (Object)Boolean.FALSE);
    private BooleanParameter m_isDebugMode = new BooleanParameter("com.arsdigita.auth.http.debug", 0, (Object)Boolean.FALSE);
    private IntegerParameter m_nonceTTL = new IntegerParameter("com.arsdigita.auth.http.nonce_ttl", 0, (Object)new Integer(60));
    private StringParameter m_serverName = new StringParameter("com.arsdigita.auth.http.server_name", 0, null);
    private IntegerParameter m_serverPort = new IntegerParameter("com.arsdigita.auth.http.server_port", 0, (Object)new Integer(80));
    private Inet4AddressRangeParameter m_clientIPRange = new Inet4AddressRangeParameter("com.arsdigita.auth.http.client_ip_range", 0, null);
    private StringParameter m_keyAlias = new StringParameter("com.arsdigita.auth.http.key_alias", 0, (Object)"authhttp");
    private StringParameter m_keyCypher = new StringParameter("com.arsdigita.auth.http.key_cypher", 0, (Object)"RSA");
    private StringParameter m_keyPassword = new StringParameter("com.arsdigita.auth.http.key_password", 0, null);
    private StringParameter m_keystorePassword = new StringParameter("com.arsdigita.auth.http.keystore_password", 0, null);
    private StringParameter m_keystorePath = new StringParameter("com.arsdigita.auth.http.keystore_path", 0, null);

    public HTTPAuthConfig() {
        this.register((Parameter)this.m_isActive);
        this.register((Parameter)this.m_isDebugMode);
        this.register((Parameter)this.m_nonceTTL);
        this.register((Parameter)this.m_serverName);
        this.register((Parameter)this.m_serverPort);
        this.register((Parameter)this.m_clientIPRange);
        this.register((Parameter)this.m_keyAlias);
        this.register((Parameter)this.m_keyCypher);
        this.register((Parameter)this.m_keyPassword);
        this.register((Parameter)this.m_keystorePassword);
        this.register((Parameter)this.m_keystorePath);
        this.loadInfo();
    }

    public final boolean isActive() {
        return Boolean.TRUE.equals(this.get((Parameter)this.m_isActive));
    }

    public final boolean isDebugMode() {
        return Boolean.TRUE.equals(this.get((Parameter)this.m_isDebugMode));
    }

    public final int getNonceTTL() {
        return (Integer)this.get((Parameter)this.m_nonceTTL);
    }

    public final String getServerName() {
        return (String)this.get((Parameter)this.m_serverName);
    }

    public final int getServerPort() {
        return (Integer)this.get((Parameter)this.m_serverPort);
    }

    public final Inet4AddressRange getClientIPRange() {
        return (Inet4AddressRange)this.get((Parameter)this.m_clientIPRange);
    }

    public final String getKeyAlias() {
        return (String)this.get((Parameter)this.m_keyAlias);
    }

    public final String getKeyCypher() {
        return (String)this.get((Parameter)this.m_keyCypher);
    }

    public final String getKeyPassword() {
        return (String)this.get((Parameter)this.m_keyPassword);
    }

    public final String getKeyStorePassword() {
        return (String)this.get((Parameter)this.m_keystorePassword);
    }

    final String getKeyStorePath() {
        return (String)this.get((Parameter)this.m_keystorePath);
    }

    public final InputStream getKeyStoreStream() {
        FileInputStream is;
        String file = this.getKeyStorePath();
        try {
            is = new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            throw new UncheckedWrapperException("cannot read keystore file " + file, (Throwable)ex);
        }
        return is;
    }

    public final KeyStore getKeyStore() {
        InputStream is = this.getKeyStoreStream();
        KeyStore store = null;
        try {
            store = KeyStore.getInstance("JKS");
        }
        catch (KeyStoreException ex) {
            throw new UncheckedWrapperException("cannot get keystore instance JKS", (Throwable)ex);
        }
        try {
            store.load(is, this.getKeyStorePassword().toCharArray());
        }
        catch (IOException ex) {
            throw new UncheckedWrapperException("cannot load keystore from " + this.getKeyStorePath(), (Throwable)ex);
        }
        catch (CertificateException ex) {
            throw new UncheckedWrapperException("cannot load keystore certificates from " + this.getKeyStorePath(), (Throwable)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new UncheckedWrapperException("cannot check integrity of keystore " + this.getKeyStorePath(), (Throwable)ex);
        }
        return store;
    }

    public final PublicKey getPublicKey() {
        KeyStore keystore = this.getKeyStore();
        Certificate cert = null;
        try {
            cert = keystore.getCertificate(this.getKeyAlias());
        }
        catch (KeyStoreException ex) {
            throw new UncheckedWrapperException("cannot get public key from keystore " + this.getKeyStorePath(), (Throwable)ex);
        }
        Assert.exists((Object)cert, Certificate.class);
        return cert.getPublicKey();
    }

    public final PrivateKey getPrivateKey() {
        KeyStore keystore = this.getKeyStore();
        Key key = null;
        try {
            key = keystore.getKey(this.getKeyAlias(), this.getKeyPassword().toCharArray());
        }
        catch (KeyStoreException ex) {
            throw new UncheckedWrapperException("cannot get private key from keystore " + this.getKeyStorePath(), (Throwable)ex);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new UncheckedWrapperException("cannot get private key from keystore " + this.getKeyStorePath(), (Throwable)ex);
        }
        catch (UnrecoverableKeyException ex) {
            throw new UncheckedWrapperException("cannot get private key from keystore " + this.getKeyStorePath(), (Throwable)ex);
        }
        Assert.exists((Object)key, Key.class);
        return (PrivateKey)key;
    }

    static {
        logger.debug((Object)"Static initalizer starting...");
        Converters.set(Inet4AddressRange.class, (Converter)new Inet4AddressRangeConvertor());
        logger.debug((Object)"Static initalizer finished.");
    }

    private static class Inet4AddressRangeParameter
    extends AbstractParameter {
        public Inet4AddressRangeParameter(String name) {
            super(name, Inet4AddressRange.class);
        }

        public Inet4AddressRangeParameter(String name, int multiplicity, Object defaalt) {
            super(name, multiplicity, defaalt, Inet4AddressRange.class);
        }
    }

    private static class Inet4AddressRangeConvertor
    implements Converter {
        private Inet4AddressRangeConvertor() {
        }

        public Object convert(Class type, Object value) {
            return Inet4AddressRange.getByName((String)value);
        }
    }
}

