/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.auth.http;

import com.arsdigita.auth.http.HTTPAuth;
import java.io.IOException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.ShortBufferException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sun.misc.BASE64Encoder;

public class HTTPAuthServlet
extends HttpServlet {
    private Cipher m_encrypt;
    public static final String AUTH = "__camden_auth";
    public static final String MAGIC = "camden";

    public void init() throws ServletException {
        PrivateKey privateKey = HTTPAuth.getConfig().getPrivateKey();
        try {
            this.m_encrypt = Cipher.getInstance(HTTPAuth.getConfig().getKeyCypher());
            this.m_encrypt.init(1, privateKey);
        }
        catch (GeneralSecurityException ex) {
            throw new ServletException((Throwable)ex);
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String nonce = req.getParameter("nonce");
        if (nonce == null) {
            throw new ServletException("nonce parameter missing");
        }
        String returnURL = req.getParameter("returnURL");
        if (returnURL == null) {
            throw new ServletException("returnURL was not specified");
        }
        String authString = MAGIC + nonce + "|" + this.getRemoteUser(req);
        try {
            byte[] encBytes = new byte[this.m_encrypt.getOutputSize(authString.length())];
            this.m_encrypt.doFinal(authString.getBytes(), 0, authString.length(), encBytes);
            authString = new BASE64Encoder().encode(encBytes);
            authString = URLEncoder.encode(authString);
        }
        catch (IllegalBlockSizeException e) {
            throw new ServletException((Throwable)e);
        }
        catch (BadPaddingException e) {
            throw new ServletException((Throwable)e);
        }
        catch (ShortBufferException e) {
            throw new ServletException((Throwable)e);
        }
        returnURL = returnURL.indexOf("?") == -1 ? returnURL + "?" : returnURL + "&";
        returnURL = returnURL + "__camden_auth=" + authString;
        res.sendRedirect(returnURL);
    }

    private String getRemoteUser(HttpServletRequest req) {
        if (HTTPAuth.getConfig().isDebugMode()) {
            return "example\\\\administrator";
        }
        return req.getRemoteUser();
    }
}

