/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.auth.http;

import com.arsdigita.auth.http.UserLogin;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.User;
import com.arsdigita.loader.PackageLoader;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.runtime.ScriptContext;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.StringParameter;
import com.arsdigita.web.Application;
import com.arsdigita.web.ApplicationType;
import org.apache.log4j.Logger;

public class Loader
extends PackageLoader {
    private static final Logger s_log = Logger.getLogger(Loader.class);
    private StringParameter m_adminEmail = new StringParameter("auth.http.admin_email", 1, null);
    private StringParameter m_adminIdent = new StringParameter("auth.http.admin_identifier", 1, null);

    public Loader() {
        this.register((Parameter)this.m_adminEmail);
        this.register((Parameter)this.m_adminIdent);
        this.loadInfo();
    }

    public void run(ScriptContext ctx) {
        new KernelExcursion(){

            public void excurse() {
                this.setEffectiveParty(Kernel.getSystemParty());
                Loader.this.setupAdministrator();
                Loader.this.setupHTTPAuth();
            }
        }.run();
    }

    private void setupHTTPAuth() {
        ApplicationType type = new ApplicationType("Auth HTTP", "com.arsdigita.auth.http.HTTPAuth");
        type.setDescription("CCM HTTP authentication administration");
        type.setSingleton(true);
        type.save();
        Application admin = Application.retrieveApplicationForPath((String)"/admin/");
        Application app = Application.createApplication((ApplicationType)type, (String)"auth-http", (String)"CCM HTTP Authentication Admin", (Application)admin);
        app.save();
    }

    private void setupAdministrator() {
        s_log.info((Object)("Administrator eMail is retrieved as: " + this.getAdminEmail()));
        DataCollection coll = SessionManager.getSession().retrieve("com.arsdigita.kernel.User");
        coll.addEqualsFilter("primaryEmail", (Object)this.getAdminEmail());
        if (!coll.next()) {
            coll.close();
            throw new IllegalStateException("administratorEmail for HTTP Authentication doesn't specify an existing user.");
        }
        User admin = User.retrieve((DataObject)coll.getDataObject());
        coll.close();
        s_log.info((Object)("Administrator is retrieved as: " + admin));
        UserLogin login = UserLogin.findByUser(admin);
        if (login == null) {
            login = UserLogin.create(admin, this.getAdminIdentifier());
            login.save();
        }
    }

    private String getAdminEmail() {
        return (String)this.get((Parameter)this.m_adminEmail);
    }

    private String getAdminIdentifier() {
        return (String)this.get((Parameter)this.m_adminIdent);
    }
}

