/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.auth.http;

import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.kernel.security.HTTPRequestCallback;
import com.arsdigita.kernel.security.HTTPResponseCallback;
import com.arsdigita.util.UncheckedWrapperException;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.spi.LoginModule;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class RedirectLoginModule
implements LoginModule {
    public static final String REDIRECT_URL = "com.arsdigita.auth.http.RedirectURL";
    private static final Logger s_log = Logger.getLogger(RedirectLoginModule.class);
    private CallbackHandler m_handler;
    private Map m_shared;

    public void initialize(Subject subject, CallbackHandler handler, Map shared, Map options) {
        this.m_handler = handler;
        this.m_shared = shared;
    }

    @Override
    public boolean commit() {
        String redirectURL = (String)this.m_shared.get(REDIRECT_URL);
        if (null == redirectURL) {
            s_log.debug((Object)"Not redirecting");
            return true;
        }
        s_log.debug((Object)("Redirecting to " + redirectURL));
        this.redirectTo(redirectURL);
        return false;
    }

    @Override
    public boolean abort() {
        return true;
    }

    @Override
    public boolean login() {
        return true;
    }

    @Override
    public boolean logout() {
        return true;
    }

    private void redirectTo(String redirectURL) {
        try {
            HTTPRequestCallback reqCB = new HTTPRequestCallback();
            HTTPResponseCallback resCB = new HTTPResponseCallback();
            this.m_handler.handle(new Callback[]{reqCB, resCB});
            HttpServletRequest req = reqCB.getRequest();
            HttpServletResponse res = resCB.getResponse();
            DispatcherHelper.sendRedirect((HttpServletRequest)req, (HttpServletResponse)res, (String)redirectURL);
        }
        catch (Exception ex) {
            throw new UncheckedWrapperException((Throwable)ex);
        }
    }
}

