/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.auth.http;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.SessionManager;

public class UserLogin
extends ACSObject {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.auth.http.UserLogin";
    public static final String LOGIN = "login";
    public static final String USER = "user";

    public UserLogin() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public UserLogin(DataObject dobj) {
        super(dobj);
    }

    public static UserLogin create(User user, String login) {
        UserLogin map = new UserLogin();
        map.setUser(user);
        map.setLogin(login.toLowerCase());
        return map;
    }

    public static UserLogin findByLogin(String login) {
        DataCollection users = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        users.addEqualsFilter(LOGIN, (Object)login.toLowerCase());
        if (users.next()) {
            DataObject dobj = users.getDataObject();
            users.close();
            return (UserLogin)DomainObjectFactory.newInstance((DataObject)dobj);
        }
        return null;
    }

    public static UserLogin findByUser(User user) {
        DataCollection users = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        users.addEqualsFilter("user.id", (Object)user.getID());
        if (users.next()) {
            DataObject dobj = users.getDataObject();
            users.close();
            return (UserLogin)DomainObjectFactory.newInstance((DataObject)dobj);
        }
        return null;
    }

    public User getUser() {
        DataObject dobj = (DataObject)this.get(USER);
        return (User)DomainObjectFactory.newInstance((DataObject)dobj);
    }

    public void setUser(User user) {
        this.setAssociation(USER, (DomainObject)user);
    }

    public String getLogin() {
        return this.get(LOGIN).toString();
    }

    public void setLogin(String login) {
        this.set(LOGIN, login.toLowerCase());
    }
}

