/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.auth.http.ui;

import com.arsdigita.auth.http.ui.UserCSVEntry;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.FileUpload;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.dispatcher.MultipartHttpServletRequest;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import org.apache.log4j.Logger;

public class UpdateUsersForm
extends Form
implements FormProcessListener,
ListCellRenderer {
    private static final Logger s_log = Logger.getLogger(UpdateUsersForm.class);
    private SimpleContainer m_uploadForm = new SimpleContainer();
    private SimpleContainer m_displayAction = new SimpleContainer();
    private FileUpload m_uploadFile = new FileUpload("fileUpload");
    private Submit m_uploadSubmit = new Submit("Upload");
    private RequestLocal m_invalidUsers = new RequestLocal();
    private RequestLocal m_failedUsers = new RequestLocal();
    private RequestLocal m_processed = new RequestLocal();
    private List m_invalidUserList;
    private List m_failedUserList;

    public UpdateUsersForm() {
        super("updateUsers");
        this.setMethod("post");
        this.setEncType("multipart/form-data");
        this.m_uploadForm.add((Component)new Label("Users file"));
        this.m_uploadForm.add((Component)this.m_uploadFile);
        this.m_uploadForm.add((Component)this.m_uploadSubmit);
        this.add((Component)this.m_uploadForm);
        this.m_invalidUserList = new List((ListModelBuilder)new UserCSVListModel(this.m_invalidUsers));
        this.m_failedUserList = new List((ListModelBuilder)new UserCSVListModel(this.m_failedUsers));
        this.m_invalidUserList.setCellRenderer((ListCellRenderer)this);
        this.m_failedUserList.setCellRenderer((ListCellRenderer)this);
        this.m_displayAction.add((Component)new Label("Users processed:"));
        this.m_displayAction.add((Component)new Label("<p>", false));
        this.m_displayAction.add((Component)new Label("Invalid users:"));
        this.m_displayAction.add((Component)this.m_invalidUserList);
        this.m_displayAction.add((Component)new Label("<p>", false));
        this.m_displayAction.add((Component)new Label("Failed users:"));
        this.m_displayAction.add((Component)this.m_failedUserList);
        this.add((Component)this.m_displayAction);
        this.addProcessListener(this);
    }

    public Component getComponent(List list, PageState state, Object value, String key, int index, boolean isSelected) {
        return new Label(value.toString());
    }

    public void process(FormSectionEvent ev) {
        PageState ps = ev.getPageState();
        FormData data = ev.getFormData();
        if (data.get((Object)this.m_uploadSubmit.getName()) != null) {
            this.m_processed.set(ps, (Object)Boolean.TRUE);
            MultipartHttpServletRequest req = (MultipartHttpServletRequest)ps.getRequest();
            try {
                UserCSVEntry entry;
                File f = req.getFile(this.m_uploadFile.getName());
                UserCSVEntry.init(new FileReader(f));
                UserCSVEntry.skipEntry();
                Vector<String> failedUsers = new Vector<String>();
                Vector<String> invalidUsers = new Vector<String>();
                this.m_failedUsers.set(ps, failedUsers);
                this.m_invalidUsers.set(ps, invalidUsers);
                while (UserCSVEntry.hasMore() && (entry = UserCSVEntry.nextEntry()) != null) {
                    if (entry.isValid()) {
                        try {
                            entry.createUser();
                            s_log.info((Object)("Created User: " + entry));
                        }
                        catch (Throwable ex) {
                            ex.printStackTrace();
                            failedUsers.add(entry.toString());
                            s_log.info((Object)("Failed to create User: " + entry));
                        }
                        continue;
                    }
                    invalidUsers.add(entry.toString());
                    s_log.info((Object)("Invalid Entry: " + entry));
                }
            }
            catch (FileNotFoundException ex) {
                throw new UncheckedWrapperException((Throwable)ex);
            }
            catch (IOException ex) {
                throw new UncheckedWrapperException((Throwable)ex);
            }
        }
    }

    public void generateXML(PageState state, Element parent) {
        this.m_displayAction.setVisible(state, this.m_processed.get(state) != null);
        super.generateXML(state, parent);
    }

    public void register(Page p) {
        super.register(p);
        p.setVisibleDefault((Component)this.m_displayAction, false);
    }

    private class UserCSVListModel
    implements ListModelBuilder {
        private boolean m_locked = false;
        private RequestLocal m_users;

        public UserCSVListModel(RequestLocal users) {
            this.m_users = users;
        }

        public ListModel makeModel(List l, PageState ps) {
            Vector userList = (Vector)this.m_users.get(ps);
            final Iterator users = userList == null ? null : userList.iterator();
            return new ListModel(){
                private String m_entry;

                public Object getElement() {
                    return this.m_entry;
                }

                public String getKey() {
                    return this.m_entry;
                }

                public boolean next() {
                    if (users == null || !users.hasNext()) {
                        this.m_entry = null;
                        return false;
                    }
                    this.m_entry = users.next().toString();
                    return true;
                }
            };
        }

        public void lock() {
            this.m_locked = true;
        }

        public boolean isLocked() {
            return this.m_locked;
        }
    }
}

