/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.Agenda;
import com.arsdigita.cms.contenttypes.ui.AgendaPropertyForm;
import com.arsdigita.cms.contenttypes.util.AgendaGlobalizationUtil;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.toolbox.ui.ComponentAccess;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import java.text.DateFormat;

public class AgendaPropertiesStep
extends SimpleEditStep {
    public static String EDIT_SHEET_NAME = "edit";

    public AgendaPropertiesStep(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        super(itemModel, parent);
        this.setDefaultEditKey(EDIT_SHEET_NAME);
        AgendaPropertyForm editSheet = new AgendaPropertyForm(itemModel, this);
        this.add(EDIT_SHEET_NAME, GlobalizationUtil.globalize((String)"cms.ui.edit"), (ComponentAccess)new WorkflowLockedComponentAccess((Component)editSheet, itemModel), editSheet.getSaveCancelSection().getCancelButton());
        this.setDisplayComponent(AgendaPropertiesStep.getAgendaPropertySheet(itemModel));
    }

    public static Component getAgendaPropertySheet(ItemSelectionModel itemModel) {
        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet((DomainObjectSelectionModel)itemModel);
        sheet.add(AgendaGlobalizationUtil.globalize("cms.contenttypes.ui.title"), "title");
        sheet.add(AgendaGlobalizationUtil.globalize("cms.contenttypes.ui.name"), "name");
        if (!ContentSection.getConfig().getHideLaunchDate()) {
            sheet.add(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.launch_date"), "launchDate", (DomainObjectPropertySheet.AttributeFormatter)new SimpleEditStep.LaunchDateAttributeFormatter());
        }
        sheet.add(AgendaGlobalizationUtil.globalize("cms.contenttypes.ui.summary"), "summary");
        sheet.add(AgendaGlobalizationUtil.globalize("cms.contenttypes.ui.agenda.agenda_date"), "agendaDate", (DomainObjectPropertySheet.AttributeFormatter)new DateTimeAttributeFormatter());
        sheet.add(AgendaGlobalizationUtil.globalize("cms.contenttypes.ui.agenda.location"), "location");
        sheet.add(AgendaGlobalizationUtil.globalize("cms.contenttypes.ui.agenda.attendees"), "attendees");
        sheet.add(AgendaGlobalizationUtil.globalize("cms.contenttypes.ui.agenda.subject_items"), "subjectItems");
        sheet.add(AgendaGlobalizationUtil.globalize("cms.contenttypes.ui.agenda.contact_info"), "contactInfo");
        sheet.add(AgendaGlobalizationUtil.globalize("cms.contenttypes.ui.agenda.creation_date"), "creationDate", (DomainObjectPropertySheet.AttributeFormatter)new DateAttributeFormatter());
        return sheet;
    }

    private static class DateTimeAttributeFormatter
    implements DomainObjectPropertySheet.AttributeFormatter {
        public String format(DomainObject obj, String attribute, PageState state) {
            if (obj != null && obj instanceof Agenda) {
                Agenda agenda = (Agenda)obj;
                Object field = agenda.get(attribute);
                if (field != null) {
                    return DateFormat.getDateTimeInstance(1, 3, GlobalizationHelper.getNegotiatedLocale()).format(field);
                }
                return (String)GlobalizationUtil.globalize((String)"cms.ui.unknown").localize();
            }
            return (String)GlobalizationUtil.globalize((String)"cms.ui.unknown").localize();
        }
    }

    private static class DateAttributeFormatter
    implements DomainObjectPropertySheet.AttributeFormatter {
        public String format(DomainObject obj, String attribute, PageState state) {
            if (obj != null && obj instanceof Agenda) {
                Agenda agenda = (Agenda)obj;
                Object field = agenda.get(attribute);
                if (field != null) {
                    return DateFormat.getDateInstance(1, GlobalizationHelper.getNegotiatedLocale()).format(field);
                }
                return (String)GlobalizationUtil.globalize((String)"cms.ui.unknown").localize();
            }
            return (String)GlobalizationUtil.globalize((String)"cms.ui.unknown").localize();
        }
    }
}

