/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.HTMLForm;
import com.arsdigita.cms.contenttypes.ui.HTMLFormPropertiesStep;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.cms.util.GlobalizationUtil;
import org.apache.log4j.Logger;

public class HTMLFormPropertyForm
extends BasicPageForm
implements FormProcessListener,
FormInitListener,
FormSubmissionListener {
    private static final Logger s_log = Logger.getLogger(HTMLFormPropertyForm.class);
    private HTMLFormPropertiesStep m_step;
    public static final String LEAD = "lead";

    public HTMLFormPropertyForm(ItemSelectionModel itemModel) {
        this(itemModel, null);
    }

    public HTMLFormPropertyForm(ItemSelectionModel itemModel, HTMLFormPropertiesStep step) {
        super("id", itemModel);
        this.m_step = step;
        this.addSubmissionListener(this);
    }

    protected void addWidgets() {
        super.addWidgets();
        this.add((Component)new Label(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.lead")));
        StringParameter leadParam = new StringParameter(LEAD);
        if (ContentSection.getConfig().mandatoryDescriptions()) {
            leadParam.addParameterListener((ParameterListener)new NotEmptyValidationListener(GlobalizationUtil.globalize((String)"cms.contenttypes.ui.description_missing")));
        }
        leadParam.addParameterListener((ParameterListener)new StringInRangeValidationListener(0, 1000));
        TextArea lead = new TextArea((ParameterModel)leadParam);
        lead.setCols(40);
        lead.setRows(5);
        this.add((Component)lead);
    }

    public void validate(FormSectionEvent e) throws FormProcessException {
        super.validate(e);
    }

    public void init(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        HTMLForm htmlform = (HTMLForm)super.initBasicWidgets(fse);
        data.put((Object)LEAD, (Object)htmlform.getLead());
    }

    public void submitted(FormSectionEvent fse) {
        if (this.m_step != null && this.getSaveCancelSection().getCancelButton().isSelected(fse.getPageState())) {
            this.m_step.cancelStreamlinedCreation(fse.getPageState());
        }
    }

    public void process(FormSectionEvent fse) {
        FormData data = fse.getFormData();
        HTMLForm htmlform = (HTMLForm)super.processBasicWidgets(fse);
        if (htmlform != null && this.getSaveCancelSection().getSaveButton().isSelected(fse.getPageState())) {
            htmlform.setLead((String)data.get((Object)LEAD));
            htmlform.save();
        }
        if (this.m_step != null) {
            this.m_step.maybeForwardToNextStep(fse.getPageState());
        }
    }
}

