/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contentassets;

import com.arsdigita.cms.contenttypes.Publication;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;

public class LibrarySignature
extends ACSObject {
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contentassets.LibrarySignature";
    public static final String LIBRARY = "library";
    public static final String SIGNATURE = "signature";
    public static final String LIBRARY_LINK = "librarylink";
    public static final String PUBLICATION = "publication";
    public static final String MISC = "misc";

    public LibrarySignature() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public LibrarySignature(BigDecimal signatureId) {
        super(new OID(BASE_DATA_OBJECT_TYPE, (Object)signatureId));
    }

    public LibrarySignature(String type) {
        super(type);
    }

    public LibrarySignature(DataObject dataObject) {
        super(dataObject);
    }

    public static LibrarySignature create(Publication publication) {
        LibrarySignature signature = new LibrarySignature();
        signature.set(PUBLICATION, publication);
        return signature;
    }

    public static DataCollection getLibrarySignatures(Publication publication) {
        Assert.exists((Object)publication, Publication.class);
        DataCollection signatures = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        signatures.addEqualsFilter(PUBLICATION, (Object)publication.getID());
        signatures.addOrder(LIBRARY);
        signatures.addOrder(SIGNATURE);
        return signatures;
    }

    public String getLibrary() {
        return (String)this.get(LIBRARY);
    }

    public void setLibrary(String library) {
        this.set(LIBRARY, library);
    }

    public String getSignature() {
        return (String)this.get(SIGNATURE);
    }

    public void setSignature(String signature) {
        this.set(SIGNATURE, signature);
    }

    public String getLibraryLink() {
        return (String)this.get(LIBRARY_LINK);
    }

    public void setLibraryLink(String libraryLink) {
        this.set(LIBRARY_LINK, libraryLink);
    }

    public String getMisc() {
        return (String)this.get(MISC);
    }

    public void setMisc(String misc) {
        this.set(MISC, misc);
    }

    public Publication getPublication() {
        DataObject dataObject = (DataObject)this.get(PUBLICATION);
        return (Publication)DomainObjectFactory.newInstance((DataObject)dataObject);
    }
}

