/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contentassets.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotEmptyValidationListener;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contentassets.LibrarySignature;
import com.arsdigita.cms.contentassets.ui.LibrarySignaturesGlobalizationUtil;
import com.arsdigita.cms.contenttypes.Publication;
import com.arsdigita.cms.ui.authoring.BasicItemForm;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;

public class LibrarySignaturesAddForm
extends BasicItemForm {
    private static final String LIBRARY = "library";
    private static final String SIGNATURE = "signature";
    private static final String LINK = "link";
    private static final String MISC = "misc";
    private final ItemSelectionModel itemModel;
    private final ACSObjectSelectionModel signatureModel;

    public LibrarySignaturesAddForm(ItemSelectionModel itemModel, ACSObjectSelectionModel signatureModel) {
        super("LibrarySignaturesAddForm", itemModel);
        this.itemModel = itemModel;
        this.signatureModel = signatureModel;
    }

    public void addWidgets() {
        this.add((Component)new Label(LibrarySignaturesGlobalizationUtil.globalize("scipublications.librarysignatures.form.library")));
        TextField library = new TextField(LIBRARY);
        library.addValidationListener((ParameterListener)new NotNullValidationListener(LibrarySignaturesGlobalizationUtil.globalize("scipublications.librarysignatures.form.library.not_null")));
        library.addValidationListener((ParameterListener)new NotEmptyValidationListener(LibrarySignaturesGlobalizationUtil.globalize("scipublications.librarysignatures.form.library.not_empty")));
        this.add((Component)library);
        this.add((Component)new Label(LibrarySignaturesGlobalizationUtil.globalize("scipublications.librarysignatures.form.signature")));
        TextField signature = new TextField(SIGNATURE);
        signature.addValidationListener((ParameterListener)new NotNullValidationListener(LibrarySignaturesGlobalizationUtil.globalize("scipublications.librarysignatures.form.signature.not_null")));
        library.addValidationListener((ParameterListener)new NotEmptyValidationListener(LibrarySignaturesGlobalizationUtil.globalize("scipublications.librarysignatures.form.signature.not_empty")));
        this.add((Component)signature);
        this.add((Component)new Label(LibrarySignaturesGlobalizationUtil.globalize("scipublications.librarysignatures.form.link")));
        this.add((Component)new TextField(LINK));
        this.add((Component)new Label(LibrarySignaturesGlobalizationUtil.globalize("scipublications.librarysignatures.form.misc")));
        this.add((Component)new TextField(MISC));
    }

    public void init(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        if (this.signatureModel.getSelectedObject(state) != null) {
            LibrarySignature signature = (LibrarySignature)this.signatureModel.getSelectedObject(state);
            FormData data = event.getFormData();
            data.put((Object)LIBRARY, (Object)signature.getLibrary());
            data.put((Object)SIGNATURE, (Object)signature.getSignature());
            data.put((Object)LINK, (Object)signature.getLibraryLink());
            data.put((Object)MISC, (Object)signature.getMisc());
        }
        this.setVisible(state, true);
    }

    public void process(FormSectionEvent event) throws FormProcessException {
        LibrarySignature signature;
        FormData data = event.getFormData();
        PageState state = event.getPageState();
        if (this.signatureModel.getSelectedObject(state) == null) {
            Publication publication = (Publication)this.itemModel.getSelectedItem(state);
            signature = LibrarySignature.create(publication);
        } else {
            signature = (LibrarySignature)this.signatureModel.getSelectedObject(state);
            this.signatureModel.setSelectedObject(state, null);
        }
        signature.setLibrary(data.getString((Object)LIBRARY));
        signature.setSignature(data.getString((Object)SIGNATURE));
        signature.setLibraryLink(data.getString((Object)LINK));
        signature.setMisc(data.getString((Object)MISC));
        signature.save();
    }
}

