/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contentassets.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.contentassets.LibrarySignature;
import com.arsdigita.cms.contentassets.ui.LibrarySignaturesGlobalizationUtil;
import com.arsdigita.cms.contentassets.ui.LibrarySignaturesStep;
import com.arsdigita.cms.contenttypes.Publication;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;

public class LibrarySignaturesTable
extends Table {
    private static final String TABLE_COL_LIBRARY = "table_col_library";
    private static final String TABLE_COL_SIGNATURE = "table_col_signature";
    private static final String TABLE_COL_LIBRARY_LINK = "table_col_library_link";
    private static final String TABLE_COL_EDIT = "table_col_edit";
    private static final String TABLE_COL_DEL = "table_col_del";
    private final LibrarySignaturesStep parent;
    private final ItemSelectionModel itemModel;
    private final ACSObjectSelectionModel signatureModel;

    public LibrarySignaturesTable(ItemSelectionModel itemModel, ACSObjectSelectionModel signatureModel, LibrarySignaturesStep parent) {
        this.parent = parent;
        this.itemModel = itemModel;
        this.signatureModel = signatureModel;
        this.setEmptyView((Component)new Label(LibrarySignaturesGlobalizationUtil.globalize("scipublications.librarysignatures.none")));
        TableColumnModel columnModel = this.getColumnModel();
        columnModel.add(new TableColumn(0, (Object)LibrarySignaturesGlobalizationUtil.globalize("scipublications.librarysignatures.columns.library"), (Object)TABLE_COL_LIBRARY));
        columnModel.add(new TableColumn(1, (Object)LibrarySignaturesGlobalizationUtil.globalize("scipublications.librarysignatures.columns.signature"), (Object)TABLE_COL_SIGNATURE));
        columnModel.add(new TableColumn(2, (Object)LibrarySignaturesGlobalizationUtil.globalize("scipublications.librarysignatures.columns.library_link"), (Object)TABLE_COL_LIBRARY_LINK));
        columnModel.add(new TableColumn(3, (Object)LibrarySignaturesGlobalizationUtil.globalize("scipublications.librarysignatures.columns.edit"), (Object)TABLE_COL_EDIT));
        columnModel.add(new TableColumn(4, (Object)LibrarySignaturesGlobalizationUtil.globalize("scipublications.librarysignatures.columns.delete"), (Object)TABLE_COL_DEL));
        this.setModelBuilder(new ModelBuilder(itemModel));
        columnModel.get(3).setCellRenderer((TableCellRenderer)new EditCellRenderer());
        columnModel.get(4).setCellRenderer((TableCellRenderer)new DeleteCellRenderer());
        this.addTableActionListener(new ActionListener());
    }

    private class ActionListener
    implements TableActionListener {
        public void cellSelected(TableActionEvent event) {
            PageState state = event.getPageState();
            LibrarySignature signature = new LibrarySignature(new BigDecimal(event.getRowKey().toString()));
            TableColumn column = LibrarySignaturesTable.this.getColumnModel().get(event.getColumn().intValue());
            if (LibrarySignaturesTable.TABLE_COL_EDIT.equals(column.getHeaderKey().toString())) {
                LibrarySignaturesTable.this.signatureModel.setSelectedObject(state, (DomainObject)signature);
                LibrarySignaturesTable.this.parent.setAddVisible(state);
            } else if (LibrarySignaturesTable.TABLE_COL_DEL.equals(column.getHeaderKey().toString())) {
                signature.delete();
            }
        }

        public void headSelected(TableActionEvent event) {
        }
    }

    private class DeleteCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            SecurityManager securityManager = CMS.getSecurityManager((PageState)state);
            Publication publication = (Publication)LibrarySignaturesTable.this.itemModel.getSelectedItem(state);
            boolean canEdit = securityManager.canAccess(state.getRequest(), "edit_item", (ContentItem)publication);
            if (canEdit) {
                ControlLink link = value instanceof GlobalizedMessage ? new ControlLink((Component)new Label((GlobalizedMessage)value)) : new ControlLink(value.toString());
                link.setConfirmation(LibrarySignaturesGlobalizationUtil.globalize("scipublications.librarysignatures.delete.confirm"));
                return link;
            }
            Label label = value instanceof GlobalizedMessage ? new Label((GlobalizedMessage)value) : new Label(value.toString());
            return label;
        }
    }

    private class EditCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            Label label;
            SecurityManager securityManager = CMS.getSecurityManager((PageState)state);
            Publication publication = (Publication)LibrarySignaturesTable.this.itemModel.getSelectedItem(state);
            boolean canEdit = securityManager.canAccess(state.getRequest(), "edit_item", (ContentItem)publication);
            if (canEdit) {
                ControlLink link;
                if (value instanceof GlobalizedMessage) {
                    link = new ControlLink((Component)new Label((GlobalizedMessage)value));
                } else {
                    if (value == null) {
                        return new Label("???");
                    }
                    link = new ControlLink(value.toString());
                }
                return link;
            }
            if (value instanceof GlobalizedMessage) {
                label = new Label((GlobalizedMessage)value);
            } else {
                if (value == null) {
                    return new Label("???");
                }
                label = new Label(value.toString());
            }
            return label;
        }
    }

    private class Model
    implements TableModel {
        private final Table table;
        private final DataCollection librarySignatures;

        public Model(Table table, PageState state, Publication publication) {
            this.table = table;
            this.librarySignatures = LibrarySignature.getLibrarySignatures(publication);
            this.librarySignatures.addOrder("library");
            this.librarySignatures.addOrder("signature");
        }

        public int getColumnCount() {
            return this.table.getColumnModel().size();
        }

        public boolean nextRow() {
            return this.librarySignatures != null && this.librarySignatures.next();
        }

        public Object getElementAt(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.librarySignatures.get("library");
                }
                case 1: {
                    return this.librarySignatures.get("signature");
                }
                case 2: {
                    return this.librarySignatures.get("librarylink");
                }
                case 3: {
                    return LibrarySignaturesGlobalizationUtil.globalize("scipublications.librarysignatures.edit");
                }
                case 4: {
                    return LibrarySignaturesGlobalizationUtil.globalize("scipublications.librarysignatures.delete");
                }
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            return this.librarySignatures.get("id");
        }
    }

    private class ModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        private final ItemSelectionModel itemModel;

        public ModelBuilder(ItemSelectionModel itemModel) {
            this.itemModel = itemModel;
        }

        public TableModel makeModel(Table table, PageState state) {
            table.getRowSelectionModel().clearSelection(state);
            Publication publication = (Publication)this.itemModel.getSelectedItem(state);
            return new Model(table, state, publication);
        }
    }
}

