/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.cms.contenttypes.MOTDItem;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.xml.Element;

public class MOTDComponent
extends SimpleComponent {
    public static final String BEBOP_XML_NS = "http://www.arsdigita.com/bebop/1.0";

    public void generateXML(PageState state, Element parent) {
        Element messages = new Element("bebop:motd", BEBOP_XML_NS);
        messages.addAttribute("id", this.getIdAttr());
        String categoryID = state.getRequest().getParameter("categoryID");
        if (categoryID == null) {
            try {
                DataCollection motds = SessionManager.getSession().retrieve("com.arsdigita.cms.contenttypes.MOTDItem");
                motds.addFilter("version = 'live'");
                motds.addOrder("id desc");
                while (motds.next()) {
                    MOTDItem msg = new MOTDItem(motds.getDataObject());
                    Element aMsg = new Element("bebop:message", BEBOP_XML_NS);
                    aMsg.addAttribute("id", msg.getID().toString());
                    aMsg.addAttribute("title", msg.getTitle());
                    aMsg.addAttribute("message", msg.getMessage());
                    aMsg.addAttribute("pubDate", msg.getPublicationDate());
                    messages.addContent(aMsg);
                }
                parent.addContent(messages);
                motds.close();
            }
            catch (PersistenceException ex) {
                // empty catch block
            }
        }
    }
}

