/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes;

import com.arsdigita.cms.ExtraXMLGenerator;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnit;
import com.arsdigita.cms.contenttypes.SciInstituteConfig;
import com.arsdigita.cms.contenttypes.SciInstituteMemberStatus;
import com.arsdigita.cms.contenttypes.ui.SciInstituteExtraXmlGenerator;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;
import java.util.List;

public class SciInstitute
extends GenericOrganizationalUnit {
    public static final String INSTITUTE_SHORT_DESCRIPTION = "instituteShortDescription";
    public static final String INSTITUTE_DESCRIPTION = "instituteDescription";
    public static final String ROLE_ENUM_NAME = "SciInstituteRole";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.contenttypes.SciInstitute";
    private static final SciInstituteConfig config = new SciInstituteConfig();

    public SciInstitute() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public SciInstitute(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public SciInstitute(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public SciInstitute(DataObject dataObject) {
        super(dataObject);
    }

    public SciInstitute(String type) {
        super(type);
    }

    public static SciInstituteConfig getConfig() {
        return config;
    }

    public String getInstituteShortDescription() {
        return (String)this.get(INSTITUTE_SHORT_DESCRIPTION);
    }

    public void setInstituteShortDescription(String shortDesc) {
        this.set(INSTITUTE_SHORT_DESCRIPTION, shortDesc);
    }

    public String getInstituteDescription() {
        return (String)this.get(INSTITUTE_DESCRIPTION);
    }

    public void setInstituteDescription(String description) {
        this.set(INSTITUTE_DESCRIPTION, description);
    }

    public boolean hasContacts() {
        boolean result = false;
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.contenttypes.getIdsOfContactsOfSciInstitute");
        query.setParameter("project", (Object)this.getID());
        result = query.size() > 0L;
        query.close();
        return result;
    }

    public boolean hasMembers(boolean merge, SciInstituteMemberStatus status) {
        String queryName;
        switch (status) {
            case ALL: {
                queryName = "com.arsdigita.cms.contenttypes.getIdsOfMembersOfSciInstitute";
                break;
            }
            case ACTIVE: {
                queryName = "com.arsdigita.cms.contenttypes.getIdsOfActiveMembersOfSciInstitute";
                break;
            }
            case ASSOCIATED: {
                queryName = "com.arsdigita.cms.contenttypes.getIdsOfAssociatedMembersOfSciInstitute";
                break;
            }
            case FORMER: {
                queryName = "com.arsdigita.cms.contenttypes.getIdsOfFormerMembersOfSciInstitute";
                break;
            }
            default: {
                queryName = "";
            }
        }
        DataQuery query = SessionManager.getSession().retrieveQuery(queryName);
        query.setParameter("institute", (Object)this.getID());
        if (query.size() > 0L) {
            query.close();
            return true;
        }
        if (merge) {
            query.close();
            DataQuery institutesQuery = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.contenttypes.getIdsOfSubInstitutesOfSciInstitute");
            institutesQuery.setParameter("institute", (Object)this.getID());
            if (query.size() > 0L) {
                BigDecimal instituteId;
                boolean result = false;
                while (institutesQuery.next() && !(result = this.hasMembers(instituteId = (BigDecimal)institutesQuery.get("instituteId"), merge, status))) {
                }
                institutesQuery.close();
                return result;
            }
            institutesQuery.close();
            return false;
        }
        query.close();
        return false;
    }

    private boolean hasMembers(BigDecimal instituteId, boolean merge, SciInstituteMemberStatus status) {
        String queryName;
        switch (status) {
            case ALL: {
                queryName = "com.arsdigita.cms.contenttypes.getIdsOfMembersOfSciDepartment";
                break;
            }
            case ACTIVE: {
                queryName = "com.arsdigita.cms.contenttypes.getIdsOfActiveMembersOfSciDepartment";
                break;
            }
            case ASSOCIATED: {
                queryName = "com.arsdigita.cms.contenttypes.getIdsOfAssociatedMembersOfDepartment";
                break;
            }
            case FORMER: {
                queryName = "com.arsdigita.cms.contenttypes.getIdsOfFormerMembersOfSciDepartment";
                break;
            }
            default: {
                queryName = "";
            }
        }
        DataQuery query = SessionManager.getSession().retrieveQuery(queryName);
        query.setParameter("institute", (Object)instituteId);
        if (query.size() > 0L) {
            query.close();
            return true;
        }
        if (merge) {
            query.close();
            DataQuery subDepartmentsQuery = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.contenttypes.getIdsOfSubDepartmentsOfSciDepartment");
            subDepartmentsQuery.setParameter("institute", (Object)instituteId);
            if (query.size() > 0L) {
                BigDecimal subinstituteId;
                boolean result = false;
                while (subDepartmentsQuery.next() && !(result = this.hasMembers(subinstituteId = (BigDecimal)subDepartmentsQuery.get("instituteId"), merge, status))) {
                }
                subDepartmentsQuery.close();
                return result;
            }
            subDepartmentsQuery.close();
            return false;
        }
        query.close();
        return false;
    }

    public List<ExtraXMLGenerator> getExtraXMLGenerators() {
        List generators = super.getExtraXMLGenerators();
        generators.add(new SciInstituteExtraXmlGenerator());
        return generators;
    }

    public String getSearchSummary() {
        return this.getInstituteShortDescription();
    }

    static {
        config.load();
    }
}

