/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnit;
import com.arsdigita.cms.contenttypes.SciInstitute;
import com.arsdigita.cms.contenttypes.ui.GenericOrgaUnitTab;
import com.arsdigita.xml.Element;
import org.apache.log4j.Logger;

public class SciInstituteDescTab
implements GenericOrgaUnitTab {
    public final Logger logger = Logger.getLogger(SciInstituteDescTab.class);

    public boolean hasData(GenericOrganizationalUnit orgaunit, PageState state) {
        boolean result;
        long start = System.currentTimeMillis();
        Desc desc = this.getData(orgaunit);
        if (desc.getDesc() == null) {
            result = false;
        } else {
            boolean bl = result = !desc.getDesc().trim().isEmpty();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)String.format("Needed %d ms to determine if institute '%s' has a description.", System.currentTimeMillis() - start, orgaunit.getName()));
        }
        return result;
    }

    public void generateXml(GenericOrganizationalUnit orgaunit, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        Desc desc = this.getData(orgaunit);
        Element descTabElem = parent.newChildElement("instituteDescription");
        if (desc.getShortDesc() != null && !desc.getShortDesc().trim().isEmpty()) {
            Element shortDescElem = descTabElem.newChildElement("shortDescription");
            shortDescElem.setText(desc.getShortDesc());
        }
        Element descElem = descTabElem.newChildElement("description");
        descElem.setText(desc.getDesc());
        this.logger.debug((Object)String.format("Generated XML for description tab of institute '%s' in %d ms", orgaunit.getName(), System.currentTimeMillis() - start));
    }

    private Desc getData(GenericOrganizationalUnit orgaunit) {
        if (!(orgaunit instanceof SciInstitute)) {
            throw new IllegalArgumentException(String.format("This tab can only process instances of 'com.arsdigita.cms.contenttypes.SciDepartment'. Provided object is of type '%s'", orgaunit.getClass().getName()));
        }
        SciInstitute institute = (SciInstitute)orgaunit;
        Desc desc = new Desc();
        desc.setShortDesc(institute.getInstituteShortDescription());
        desc.setDesc(institute.getInstituteDescription());
        return desc;
    }

    private class Desc {
        private String shortDesc;
        private String desc;

        private Desc() {
        }

        public String getShortDesc() {
            return this.shortDesc;
        }

        public void setShortDesc(String shortDesc) {
            this.shortDesc = shortDesc;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }
    }
}

