/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnit;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.cms.contenttypes.SciInstitute;
import com.arsdigita.cms.contenttypes.ui.GenericOrgaUnitTab;
import com.arsdigita.cms.contenttypes.ui.SciInstituteMembersTabConfig;
import com.arsdigita.cms.contenttypes.ui.panels.CompareFilter;
import com.arsdigita.cms.contenttypes.ui.panels.Paginator;
import com.arsdigita.cms.contenttypes.ui.panels.TextFilter;
import com.arsdigita.cms.dispatcher.SimpleXMLGenerator;
import com.arsdigita.globalization.Globalization;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class SciInstituteMembersTab
implements GenericOrgaUnitTab {
    private final Logger logger = Logger.getLogger(SciInstituteMembersTab.class);
    private static final SciInstituteMembersTabConfig config = new SciInstituteMembersTabConfig();
    private static final String STATUS_PARAM = "memberStatus";
    private static final String SURNAME_PARAM = "memberSurname";
    private final CompareFilter statusFilter = new CompareFilter("memberStatus", "status", false, false, false);
    private final TextFilter surnameFilter = new TextFilter("memberSurname", "surname");

    public SciInstituteMembersTab() {
        String[] statusValues;
        for (String status : statusValues = config.getStatusValues()) {
            this.statusFilter.addOption(status, status);
        }
    }

    public boolean hasData(GenericOrganizationalUnit orgaunit, PageState state) {
        if (orgaunit.getPersons() != null && orgaunit.getPersons().size() > 0L) {
            return true;
        }
        if (config.isMergingMembers()) {
            DataCollection persons = this.getData(orgaunit, state);
            return persons != null && !persons.isEmpty();
        }
        return false;
    }

    public void generateXml(GenericOrganizationalUnit orgaunit, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        DataCollection persons = this.getData(orgaunit, state);
        HttpServletRequest request = state.getRequest();
        this.applySurnameFilter((DataQuery)persons, request);
        Element depMembersElem = parent.newChildElement("instituteMembers");
        Element filtersElem = depMembersElem.newChildElement("filters");
        this.statusFilter.generateXml(filtersElem);
        if (persons == null || persons.isEmpty()) {
            if (this.surnameFilter != null && this.surnameFilter.getFilter() != null && !this.surnameFilter.getFilter().trim().isEmpty()) {
                this.surnameFilter.generateXml(filtersElem);
            }
            depMembersElem.newChildElement("noMembers");
            return;
        }
        Paginator paginator = new Paginator(request, (int)persons.size(), config.getPageSize());
        if (paginator.getPageCount() > config.getEnableSearchLimit() || this.surnameFilter.getFilter() != null && !this.surnameFilter.getFilter().trim().isEmpty()) {
            this.surnameFilter.generateXml(filtersElem);
        }
        paginator.applyLimits((DataQuery)persons);
        paginator.generateXml(depMembersElem);
        while (persons.next()) {
            this.generateMemberXml(new GenericPerson(persons.getDataObject()), depMembersElem, state);
        }
        this.logger.debug((Object)String.format("Generated members list of institute'%s' in %d ms.", orgaunit.getName(), System.currentTimeMillis() - start));
    }

    protected DataCollection getData(GenericOrganizationalUnit orgaunit, PageState state) {
        long start = System.currentTimeMillis();
        if (!(orgaunit instanceof SciInstitute)) {
            throw new IllegalArgumentException(String.format("This tab can only process instances of 'com.arsdigita.cms.contenttypes.SciInstitute'. Provided object is of type '%s'", orgaunit.getClass().getName()));
        }
        DataQuery personBundlesQuery = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.contenttypes.getIdsOfMembersOfOrgaUnits");
        ArrayList<String> orgaunitsIds = new ArrayList<String>();
        if (config.isMergingMembers()) {
            DataQuery departmentsQuery = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.contenttypes.getIdsOfSubordinateOrgaUnitsRecursivlyWithAssocType");
            departmentsQuery.setParameter("orgaunitId", (Object)orgaunit.getContentBundle().getID().toString());
            departmentsQuery.setParameter("assocType", (Object)"DepartmentOf");
            while (departmentsQuery.next()) {
                orgaunitsIds.add(departmentsQuery.get("orgaunitId").toString());
            }
        } else {
            orgaunitsIds.add(orgaunit.getContentBundle().getID().toString());
        }
        personBundlesQuery.setParameter("orgaunitIds", orgaunitsIds);
        this.applyStatusFilter(personBundlesQuery, state.getRequest());
        StringBuilder filterBuilder = new StringBuilder();
        while (personBundlesQuery.next()) {
            if (filterBuilder.length() > 0) {
                filterBuilder.append(',');
            }
            filterBuilder.append(personBundlesQuery.get("memberId").toString());
        }
        DataCollection membersQuery = SessionManager.getSession().retrieve("com.arsdigita.cms.contenttypes.GenericPerson");
        if (filterBuilder.length() == 0) {
            return null;
        }
        membersQuery.addFilter(String.format("parent.id in (%s)", filterBuilder.toString()));
        membersQuery.addOrder("surname");
        membersQuery.addOrder("givenname");
        this.logger.debug((Object)String.format("Got members of institute '%s'in '%d ms'. MergeMembers is set to '%b'.", orgaunit.getName(), System.currentTimeMillis() - start, config.isMergingMembers()));
        return membersQuery;
    }

    private void applyStatusFilter(DataQuery persons, HttpServletRequest request) {
        String filter;
        String statusValue = Globalization.decodeParameter((HttpServletRequest)request, (String)STATUS_PARAM);
        if (statusValue != null && !statusValue.trim().isEmpty()) {
            this.statusFilter.setValue(statusValue);
        }
        if ((filter = this.statusFilter.getFilter()) != null && !filter.trim().isEmpty()) {
            persons.addFilter(filter);
        }
    }

    private void applySurnameFilter(DataQuery persons, HttpServletRequest request) {
        String filter;
        String surnameValue = Globalization.decodeParameter((HttpServletRequest)request, (String)SURNAME_PARAM);
        if (surnameValue != null && !surnameValue.trim().isEmpty()) {
            this.surnameFilter.setValue(surnameValue);
        }
        if ((filter = this.surnameFilter.getFilter()) != null && !filter.trim().isEmpty()) {
            persons.addFilter(filter);
        }
    }

    protected void generateMemberXml(BigDecimal memberId, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        GenericPerson member = new GenericPerson(memberId);
        this.logger.debug((Object)String.format("Got domain object for member '%s' in %d ms.", member.getFullName(), System.currentTimeMillis() - start));
        this.generateMemberXml(member, parent, state);
    }

    protected void generateMemberXml(GenericPerson member, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        XmlGenerator generator = new XmlGenerator((ContentItem)member);
        generator.setItemElemName("member", "");
        generator.generateXML(state, parent, "");
        this.logger.debug((Object)String.format("Generated XML for member '%s' in %d ms.", member.getFullName(), System.currentTimeMillis() - start));
    }

    static {
        config.load();
    }

    private class XmlGenerator
    extends SimpleXMLGenerator {
        private final ContentItem item;

        public XmlGenerator(ContentItem item) {
            this.item = item;
        }

        protected ContentItem getContentItem(PageState state) {
            return this.item;
        }
    }
}

