/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.contenttypes.SciInstitute;
import com.arsdigita.cms.contenttypes.SciInstituteConfig;
import com.arsdigita.cms.contenttypes.ui.GenericOrganizationalUnitPropertiesStep;
import com.arsdigita.cms.contenttypes.ui.GenericOrganizationalUnitPropertyForm;
import com.arsdigita.cms.contenttypes.ui.SciInstituteGlobalizationUtil;
import com.arsdigita.cms.contenttypes.ui.SciInstitutePropertiesStep;
import com.arsdigita.globalization.GlobalizedMessage;

public class SciInstitutePropertyForm
extends GenericOrganizationalUnitPropertyForm
implements FormProcessListener,
FormInitListener,
FormSubmissionListener {
    public static final String ID = "SciInstituteEdit";
    private static final SciInstituteConfig config = SciInstitute.getConfig();

    public SciInstitutePropertyForm(ItemSelectionModel itemModel) {
        this(itemModel, null);
    }

    public SciInstitutePropertyForm(ItemSelectionModel itemModel, SciInstitutePropertiesStep step) {
        super(itemModel, (GenericOrganizationalUnitPropertiesStep)step);
        this.addSubmissionListener(this);
    }

    public void addWidgets() {
        super.addWidgets();
        this.add((Component)new Label(SciInstituteGlobalizationUtil.globalize("sciinstitute.ui.shortdesc")));
        StringParameter shortDescParam = new StringParameter("instituteShortDescription");
        TextArea shortDesc = new TextArea((ParameterModel)shortDescParam);
        shortDesc.addValidationListener((ParameterListener)new StringInRangeValidationListener(0, config.getShortDescMaxLength().intValue()));
        shortDesc.setCols(75);
        shortDesc.setRows(5);
        this.add((Component)shortDesc);
    }

    public void init(FormSectionEvent fse) throws FormProcessException {
        super.init(fse);
        FormData data = fse.getFormData();
        SciInstitute institute = (SciInstitute)super.initBasicWidgets(fse);
        data.put((Object)"instituteShortDescription", (Object)institute.getInstituteShortDescription());
    }

    public void process(FormSectionEvent fse) throws FormProcessException {
        super.process(fse);
        FormData data = fse.getFormData();
        PageState state = fse.getPageState();
        SciInstitute institute = (SciInstitute)super.processBasicWidgets(fse);
        if (institute != null && this.getSaveCancelSection().getSaveButton().isSelected(state)) {
            institute.setInstituteShortDescription((String)data.get((Object)"instituteShortDescription"));
            institute.save();
        }
        this.init(fse);
    }

    public GlobalizedMessage getTitleLabel() {
        return SciInstituteGlobalizationUtil.globalize("sciinstitute.ui.title");
    }
}

