/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentTypeCollection;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnit;
import com.arsdigita.cms.contenttypes.SciInstitute;
import com.arsdigita.cms.contenttypes.ui.GenericOrgaUnitTab;
import com.arsdigita.cms.contenttypes.ui.SciInstitutePublicationsTabConfig;
import com.arsdigita.cms.contenttypes.ui.panels.Paginator;
import com.arsdigita.cms.contenttypes.ui.panels.SelectFilter;
import com.arsdigita.cms.contenttypes.ui.panels.TextFilter;
import com.arsdigita.cms.dispatcher.SimpleXMLGenerator;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.globalization.Globalization;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.persistence.CompoundFilter;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.FilterFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class SciInstitutePublicationsTab
implements GenericOrgaUnitTab {
    private final Logger logger = Logger.getLogger(SciInstitutePublicationsTab.class);
    private static final SciInstitutePublicationsTabConfig config = new SciInstitutePublicationsTabConfig();
    private static final String YEAR_PARAM = "yearOfPublication";
    private static final String TITLE_PARAM = "title";
    private static final String AUTHOR_PARAM = "author";
    private final SelectFilter yearFilter = new SelectFilter("yearOfPublication", "yearOfPublication", true, true, false, true, true);
    private final TextFilter titleFilter = new TextFilter("title", "title");
    private final TextFilter authorFilter = new TextFilter("author", "authorsStr");
    private boolean excludeWorkingPapers = false;
    private boolean onlyWorkingPapers = false;

    public void setExcludeWorkingPapers(boolean excludeWorkingPapers) {
        this.excludeWorkingPapers = excludeWorkingPapers;
    }

    public void setOnlyWorkingPapers(boolean onlyWorkingPapers) {
        this.onlyWorkingPapers = onlyWorkingPapers;
    }

    public boolean hasData(GenericOrganizationalUnit orgaunit, PageState state) {
        long start = System.currentTimeMillis();
        ContentTypeCollection types = ContentType.getAllContentTypes();
        types.addFilter("associatedObjectType = 'com.arsdigita.cms.contenttypes.Publication'");
        if (types.size() == 0L) {
            return false;
        }
        types.close();
        DataCollection data = this.getData(orgaunit);
        boolean result = data != null && !data.isEmpty();
        this.logger.debug((Object)String.format("Needed %d ms to determine if institute '%s' has publications.", System.currentTimeMillis() - start, orgaunit.getName()));
        return result;
    }

    public void generateXml(GenericOrganizationalUnit orgaunit, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        DataCollection publications = this.getData(orgaunit);
        HttpServletRequest request = state.getRequest();
        Element publicationsElem = parent.newChildElement("institutePublications");
        String yearValue = Globalization.decodeParameter((HttpServletRequest)request, (String)YEAR_PARAM);
        String titleValue = Globalization.decodeParameter((HttpServletRequest)request, (String)TITLE_PARAM);
        String authorValue = Globalization.decodeParameter((HttpServletRequest)request, (String)AUTHOR_PARAM);
        Element filtersElem = publicationsElem.newChildElement("filters");
        if (this.excludeWorkingPapers && this.onlyWorkingPapers) {
            throw new IllegalStateException("onlyWorkingPapers and excludeWorkingPapers are both set to true. This is not possible.");
        }
        if (this.excludeWorkingPapers) {
            publications.addFilter("objectType != 'com.arsdigita.cms.contenttypes.WorkingPaper'");
        }
        if (this.onlyWorkingPapers) {
            publications.addFilter("objectType = 'com.arsdigita.cms.contenttypes.WorkingPaper'");
        }
        if ((yearValue == null || yearValue.trim().isEmpty() || "--NONE--".equals(yearValue)) && (titleValue == null || titleValue.trim().isEmpty()) && (authorValue == null || authorValue.trim().isEmpty())) {
            publicationsElem.newChildElement("greeting");
            publications.addOrder("yearOfPublication desc");
            publications.addOrder("case when (authorsStr is null) then 'zzzz' else authorsStr end asc");
            publications.addOrder("title asc");
            this.yearFilter.setDataQuery((DataQuery)publications, YEAR_PARAM);
            this.yearFilter.generateXml(filtersElem);
            this.titleFilter.generateXml(filtersElem);
            this.authorFilter.generateXml(filtersElem);
            publications.setRange(Integer.valueOf(1), Integer.valueOf(config.getGreetingSize() + 1));
        } else {
            publications.addOrder("case when (authorsStr is null) then 'zzzz' else authorsStr end asc");
            publications.addOrder("title asc");
            DataCollection yearQuery = this.getData(orgaunit);
            this.yearFilter.setDataQuery((DataQuery)yearQuery, YEAR_PARAM);
            this.applyYearFilter((DataQuery)publications, request);
            this.applyTitleFilter((DataQuery)publications, request);
            this.applyAuthorFilter((DataQuery)publications, request);
            this.applyTitleFilter((DataQuery)yearQuery, request);
            this.applyAuthorFilter((DataQuery)yearQuery, request);
            if (publications.isEmpty()) {
                this.yearFilter.generateXml(filtersElem);
                this.titleFilter.generateXml(filtersElem);
                this.authorFilter.generateXml(filtersElem);
                publicationsElem.newChildElement("noPublications");
                return;
            }
            Paginator paginator = new Paginator(request, (int)publications.size(), config.getPageSize());
            this.yearFilter.generateXml(filtersElem);
            if (paginator.getPageCount() > config.getEnableSearchLimit() || Globalization.decodeParameter((HttpServletRequest)request, (String)TITLE_PARAM) != null && !Globalization.decodeParameter((HttpServletRequest)request, (String)TITLE_PARAM).trim().isEmpty()) {
                this.titleFilter.generateXml(filtersElem);
            }
            if (paginator.getPageCount() > config.getEnableSearchLimit() || Globalization.decodeParameter((HttpServletRequest)request, (String)AUTHOR_PARAM) != null && !Globalization.decodeParameter((HttpServletRequest)request, (String)AUTHOR_PARAM).trim().isEmpty()) {
                this.authorFilter.generateXml(filtersElem);
            }
            paginator.applyLimits((DataQuery)publications);
            paginator.generateXml(publicationsElem);
        }
        while (publications.next()) {
            this.generatePublicationXml((BigDecimal)publications.get("id"), (String)publications.get("objectType"), publicationsElem, state);
        }
        this.logger.debug((Object)String.format("Generated publications list of institute '%s' in %d ms.", orgaunit.getName(), System.currentTimeMillis() - start));
    }

    protected DataCollection getData(GenericOrganizationalUnit orgaunit) {
        long start = System.currentTimeMillis();
        if (!(orgaunit instanceof SciInstitute)) {
            throw new IllegalArgumentException(String.format("This tab can only process instances of 'com.arsdigita.cms.contenttypes.SciInstitute'. Provided object is of type '%s'", orgaunit.getClass().getName()));
        }
        DataQuery publicationBundlesQuery = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.contenttypes.getIdsOfPublicationsForOrgaUnit");
        ArrayList<String> orgaunitIds = new ArrayList<String>();
        if (config.isMergingPublications()) {
            DataQuery departmentsQuery = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.contenttypes.getIdsOfSubordinateOrgaUnitsRecursivlyWithAssocType");
            departmentsQuery.setParameter("orgaunitId", (Object)orgaunit.getContentBundle().getID().toString());
            departmentsQuery.setParameter("assocType", (Object)"DepartmentOf");
            while (departmentsQuery.next()) {
                orgaunitIds.add(departmentsQuery.get("orgaunitId").toString());
            }
        } else {
            orgaunitIds.add(orgaunit.getID().toString());
        }
        publicationBundlesQuery.setParameter("orgaunitIds", orgaunitIds);
        StringBuilder filterBuilder = new StringBuilder();
        while (publicationBundlesQuery.next()) {
            if (filterBuilder.length() > 0) {
                filterBuilder.append(',');
            }
            filterBuilder.append(publicationBundlesQuery.get("publicationId").toString());
        }
        DataCollection publicationsQuery = SessionManager.getSession().retrieve("com.arsdigita.cms.contenttypes.Publication");
        if (filterBuilder.length() == 0) {
            return null;
        }
        publicationsQuery.addFilter(String.format("parent.id in (%s)", filterBuilder.toString()));
        if (Kernel.getConfig().languageIndependentItems()) {
            FilterFactory filterFactory = publicationsQuery.getFilterFactory();
            CompoundFilter filter = filterFactory.or().addFilter(filterFactory.equals("language", (Object)GlobalizationHelper.getNegotiatedLocale().getLanguage())).addFilter((Filter)filterFactory.and().addFilter(filterFactory.equals("language", (Object)GlobalizationHelper.LANG_INDEPENDENT)).addFilter(filterFactory.notIn("parent", "com.arsdigita.navigation.getParentIDsOfMatchedItems").set("language", (Object)GlobalizationHelper.getNegotiatedLocale().getLanguage())));
            publicationsQuery.addFilter((Filter)filter);
        } else {
            publicationsQuery.addEqualsFilter("language", (Object)GlobalizationHelper.getNegotiatedLocale().getLanguage());
        }
        this.logger.debug((Object)String.format("Got publications of institute '%s'in '%d ms'. MergeProjects is set to '%b'.", orgaunit.getName(), System.currentTimeMillis() - start, config.isMergingPublications()));
        return publicationsQuery;
    }

    private void applyYearFilter(DataQuery publications, HttpServletRequest request) {
        String yearValue = Globalization.decodeParameter((HttpServletRequest)request, (String)YEAR_PARAM);
        if (yearValue != null && !yearValue.trim().isEmpty()) {
            this.yearFilter.setValue(yearValue);
        }
        if (this.yearFilter.getFilter() != null && !this.yearFilter.getFilter().isEmpty()) {
            publications.addFilter(this.yearFilter.getFilter());
        }
    }

    private void applyTitleFilter(DataQuery publications, HttpServletRequest request) {
        String titleValue = Globalization.decodeParameter((HttpServletRequest)request, (String)TITLE_PARAM);
        if (titleValue != null && !titleValue.trim().isEmpty()) {
            this.titleFilter.setValue(titleValue);
        }
        if (this.titleFilter.getFilter() != null && !this.titleFilter.getFilter().isEmpty()) {
            publications.addFilter(this.titleFilter.getFilter());
        }
    }

    private void applyAuthorFilter(DataQuery publications, HttpServletRequest request) {
        String authorValue = Globalization.decodeParameter((HttpServletRequest)request, (String)AUTHOR_PARAM);
        if (authorValue != null && !authorValue.trim().isEmpty()) {
            this.authorFilter.setValue(authorValue);
        }
        if (this.authorFilter.getFilter() != null && !this.authorFilter.getFilter().isEmpty()) {
            publications.addFilter(this.authorFilter.getFilter());
        }
    }

    private void generatePublicationXml(BigDecimal publicationId, String objectType, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        ContentPage publication = (ContentPage)DomainObjectFactory.newInstance((OID)new OID(objectType, (Object)publicationId));
        this.logger.debug((Object)String.format("Got domain object for publication '%s' in %d ms.", publication.getName(), System.currentTimeMillis() - start));
        this.generatePublicationXml(publication, parent, state);
    }

    private void generatePublicationXml(ContentPage publication, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        XmlGenerator generator = new XmlGenerator((ContentItem)publication);
        generator.setListMode(true);
        generator.setItemElemName("publications", "");
        generator.generateXML(state, parent, "");
        this.logger.debug((Object)String.format("Generated XML for publication '%s' in %d ms.", publication.getName(), System.currentTimeMillis() - start));
    }

    static {
        config.load();
    }

    private class XmlGenerator
    extends SimpleXMLGenerator {
        private final ContentItem item;

        public XmlGenerator(ContentItem item) {
            this.item = item;
        }

        protected ContentItem getContentItem(PageState state) {
            return this.item;
        }
    }
}

