/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.contenttypes.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.RelationAttributeCollection;
import com.arsdigita.cms.contenttypes.GenericContact;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnit;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitContactCollection;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitPersonCollection;
import com.arsdigita.cms.contenttypes.GenericOrganizationalUnitSubordinateCollection;
import com.arsdigita.cms.contenttypes.GenericPerson;
import com.arsdigita.cms.contenttypes.SciInstitute;
import com.arsdigita.cms.contenttypes.ui.GenericOrgaUnitTab;
import com.arsdigita.cms.contenttypes.ui.SciInstituteSummaryTabConfig;
import com.arsdigita.cms.dispatcher.SimpleXMLGenerator;
import com.arsdigita.globalization.GlobalizationHelper;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.log4j.Logger;

public class SciInstituteSummaryTab
implements GenericOrgaUnitTab {
    private final Logger logger = Logger.getLogger(SciInstituteSummaryTab.class);
    private static final SciInstituteSummaryTabConfig config = new SciInstituteSummaryTabConfig();

    public boolean hasData(GenericOrganizationalUnit orgaunit, PageState state) {
        return true;
    }

    public void generateXml(GenericOrganizationalUnit orgaunit, Element parent, PageState state) {
        if (!(orgaunit instanceof SciInstitute)) {
            throw new IllegalArgumentException(String.format("This tab can only process instances of SciInstitute.The provided object is of type '%s',", orgaunit.getClass().getName()));
        }
        long start = System.currentTimeMillis();
        SciInstitute institute = (SciInstitute)orgaunit;
        Element instituteSummaryElem = parent.newChildElement("instituteSummary");
        this.generateShortDescXml(institute, instituteSummaryElem);
        if (config.isShowingHead()) {
            this.generateHeadOfInstituteXml(institute, instituteSummaryElem, state);
        }
        if (config.isShowingDepartments().booleanValue()) {
            this.generateDepartmentsXml(institute, instituteSummaryElem, state);
        }
        if (config.isShowingContacts()) {
            this.generateContactsXml(institute, instituteSummaryElem, state);
        }
        this.logger.debug((Object)String.format("Generated XML for summary tab of institute '%s' in %d ms.", orgaunit.getName(), System.currentTimeMillis() - start));
    }

    protected void generateShortDescXml(SciInstitute department, Element parent) {
        long start = System.currentTimeMillis();
        if (department != null && department.getInstituteShortDescription() != null && !department.getInstituteShortDescription().trim().isEmpty()) {
            Element shortDescElem = parent.newChildElement("shortDesc");
            shortDescElem.setText(department.getInstituteShortDescription());
        }
        this.logger.debug((Object)String.format("Generated short desc XML for institute '%s' in %d ms", department.getName(), System.currentTimeMillis() - start));
    }

    protected void generateHeadOfInstituteXml(SciInstitute institute, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        String headRoleStr = config.getHeadRole();
        String activeStatusStr = config.getActiveStatus();
        String[] headRoles = headRoleStr.split(",");
        String[] activeStatuses = activeStatusStr.split(",");
        StringBuffer roleFilter = new StringBuffer();
        for (String headRole : headRoles) {
            if (roleFilter.length() > 0) {
                roleFilter.append(',');
            }
            roleFilter.append(String.format("%s = '%s'", "link.role_name", headRole));
        }
        StringBuffer statusFilter = new StringBuffer();
        for (String activeStatus : activeStatuses) {
            if (statusFilter.length() > 0) {
                statusFilter.append(",");
            }
            statusFilter.append(String.format("%s = '%s'", "link.status", activeStatus));
        }
        Element headsElem = parent.newChildElement("heads");
        GenericOrganizationalUnitPersonCollection heads = institute.getPersons();
        heads.addFilter(roleFilter.toString());
        heads.addFilter(statusFilter.toString());
        heads.addOrder("name");
        while (heads.next()) {
            this.generateMemberXml(heads.getPerson(), headsElem, state);
        }
        this.logger.debug((Object)String.format("Generated head of department XML for institute '%s' in %d ms", institute.getName(), System.currentTimeMillis() - start));
    }

    protected void generateHeadOfDepartmentXml(GenericOrganizationalUnit department, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        String headRoleStr = config.getHeadRole();
        String activeStatusStr = config.getActiveStatus();
        String[] headRoles = headRoleStr.split(",");
        String[] activeStatuses = activeStatusStr.split(",");
        StringBuffer roleFilter = new StringBuffer();
        for (String headRole : headRoles) {
            if (roleFilter.length() > 0) {
                roleFilter.append(',');
            }
            roleFilter.append(String.format("%s = '%s'", "link.role_name", headRole));
        }
        StringBuffer statusFilter = new StringBuffer();
        for (String activeStatus : activeStatuses) {
            if (statusFilter.length() > 0) {
                statusFilter.append(",");
            }
            statusFilter.append(String.format("%s = '%s'", "link.status", activeStatus));
        }
        GenericOrganizationalUnitPersonCollection headsCollection = department.getPersons();
        headsCollection.addFilter(roleFilter.toString());
        headsCollection.addFilter(statusFilter.toString());
        ArrayList<GenericPerson> heads = new ArrayList<GenericPerson>();
        while (headsCollection.next()) {
            heads.add(headsCollection.getPerson());
        }
        Collections.sort(heads, new Comparator<GenericPerson>(){

            @Override
            public int compare(GenericPerson person1, GenericPerson person2) {
                String name1 = String.format("%s %s", person1.getSurname(), person1.getGivenName());
                String name2 = String.format("%s %s", person2.getSurname(), person2.getGivenName());
                return name1.compareTo(name2);
            }
        });
        if (!heads.isEmpty()) {
            Element headsElem = parent.newChildElement("heads");
            for (GenericPerson head : heads) {
                this.generateMemberXml(head, headsElem, state);
            }
        }
        this.logger.debug((Object)String.format("Generated head of department XML for department '%s' in %d ms", department.getName(), System.currentTimeMillis() - start));
    }

    protected void generateDepartmentsXml(SciInstitute institute, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        GenericOrganizationalUnitSubordinateCollection departments = institute.getSubordinateOrgaUnits();
        departments.addFilter(String.format("%s = '%s'", "link.assocType", "DepartmentOf"));
        Element subDepsElem = parent.newChildElement("departments");
        while (departments.next()) {
            this.generateDepartmentXml(departments.getGenericOrganizationalUnit(), subDepsElem, state);
        }
        this.logger.debug((Object)String.format("Generated sub departments XML for institute '%s' in %d ms", institute.getName(), System.currentTimeMillis() - start));
    }

    protected void generateDepartmentXml(GenericOrganizationalUnit orgaunit, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        if (!orgaunit.getClass().getName().equals("com.arsdigita.cms.contenttypes.SciDepartment")) {
            throw new IllegalArgumentException(String.format("Can't process orgaunit '%s' as department because the orgaunit is not a SciDepartment but of type '%s'.", orgaunit.getName(), orgaunit.getClass().getName()));
        }
        GenericOrganizationalUnit department = orgaunit;
        Element subDepElem = parent.newChildElement("department");
        subDepElem.addAttribute("oid", department.getOID().toString());
        Element nameElem = subDepElem.newChildElement("title");
        nameElem.setText(department.getTitle());
        this.generateHeadOfDepartmentXml(department, subDepElem, state);
        this.logger.debug((Object)String.format("Generated XML for department '%s' in %d ms", orgaunit.getName(), System.currentTimeMillis() - start));
    }

    protected void generateMemberXml(BigDecimal memberId, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        GenericPerson member = new GenericPerson(memberId);
        this.logger.debug((Object)String.format("Got domain object for member '%s' in %d ms.", member.getFullName(), System.currentTimeMillis() - start));
        this.generateMemberXml(member, parent, state);
    }

    protected void generateMemberXml(GenericPerson member, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        XmlGenerator generator = new XmlGenerator((ContentItem)member);
        generator.setItemElemName("head", "");
        generator.setUseExtraXml(false);
        generator.generateXML(state, parent, "");
        this.logger.debug((Object)String.format("Generated XML for member '%s' in %d ms.", member.getFullName(), System.currentTimeMillis() - start));
    }

    protected void generateContactsXml(SciInstitute department, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        GenericOrganizationalUnitContactCollection contacts = department.getContacts();
        if (contacts == null || contacts.isEmpty()) {
            return;
        }
        Element contactsElem = parent.newChildElement("contacts");
        while (contacts.next()) {
            this.generateContactXml(contacts.getContact(), contacts.getContactType(), contactsElem, state);
        }
        this.logger.debug((Object)String.format("Generated XML for contacts of project '%s' in %d ms.", department.getName(), System.currentTimeMillis() - start));
    }

    protected void generateContactXml(GenericContact contact, String contactType, Element parent, PageState state) {
        long start = System.currentTimeMillis();
        XmlGenerator generator = new XmlGenerator((ContentItem)contact);
        generator.setUseExtraXml(false);
        generator.setItemElemName("contact", "");
        generator.addItemAttribute("contactType", this.getContactTypeName(contactType));
        generator.generateXML(state, parent, "");
        this.logger.debug((Object)String.format("Generated XML for contact '%s' in %d ms.", contact.getName(), System.currentTimeMillis() - start));
    }

    private String getContactTypeName(String contactTypeKey) {
        RelationAttributeCollection relAttrs = new RelationAttributeCollection();
        relAttrs.addFilter(String.format("attribute = '%s'", "GenericContactTypes"));
        relAttrs.addFilter(String.format("attr_key = '%s'", contactTypeKey));
        relAttrs.addFilter(String.format("lang = '%s'", GlobalizationHelper.getNegotiatedLocale().getLanguage()));
        if (relAttrs.isEmpty()) {
            return contactTypeKey;
        }
        relAttrs.next();
        String result = relAttrs.getName();
        relAttrs.close();
        return result;
    }

    static {
        config.load();
    }

    private class XmlGenerator
    extends SimpleXMLGenerator {
        private final ContentItem item;

        public XmlGenerator(ContentItem item) {
            this.item = item;
        }

        protected ContentItem getContentItem(PageState state) {
            return this.item;
        }
    }
}

